/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.CharUtils;
import org.joda.primitives.list.impl.AbstractCharList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayCharList
extends AbstractCharList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private char[] data;
    private int size;

    public ArrayCharList() {
        this.data = CharUtils.EMPTY_CHAR_ARRAY;
    }

    public ArrayCharList(int n) {
        this.data = n <= 0 ? CharUtils.EMPTY_CHAR_ARRAY : new char[n];
    }

    public ArrayCharList(char[] cArray) {
        if (cArray == null) {
            this.data = CharUtils.EMPTY_CHAR_ARRAY;
        } else {
            this.data = (char[])cArray.clone();
            this.size = cArray.length;
        }
    }

    public ArrayCharList(Collection<Character> collection) {
        if (collection == null) {
            this.data = CharUtils.EMPTY_CHAR_ARRAY;
        } else if (collection instanceof ArrayCharList) {
            ArrayCharList arrayCharList = (ArrayCharList)collection;
            this.data = new char[arrayCharList.size];
            System.arraycopy(arrayCharList.data, 0, this.data, 0, arrayCharList.size);
            this.size = arrayCharList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public char getChar(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, char c) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = c;
        ++this.size;
        return true;
    }

    @Override
    public char removeCharAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        char c = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return c;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public char set(int n, char c) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        char c2 = this.data[n];
        this.data[n] = c;
        return c2;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            char[] cArray = new char[this.size];
            System.arraycopy(this.data, 0, cArray, 0, this.size);
            this.data = cArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(char c) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, char[] cArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        int n2 = cArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(cArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    public String toStringContents() {
        return new String(this.data, 0, this.size);
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayCharList arrayCharList = (ArrayCharList)super.clone();
        arrayCharList.data = (char[])this.data.clone();
        return arrayCharList;
    }

    @Override
    protected void arrayCopy(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(this.data, n, cArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        char[] cArray = new char[n3];
        System.arraycopy(this.data, 0, cArray, 0, n2);
        this.data = cArray;
    }
}

