/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.DoubleUtils;
import org.joda.primitives.list.impl.AbstractDoubleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayDoubleList
extends AbstractDoubleList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private double[] data;
    private int size;

    public ArrayDoubleList() {
        this.data = DoubleUtils.EMPTY_DOUBLE_ARRAY;
    }

    public ArrayDoubleList(int n) {
        this.data = n <= 0 ? DoubleUtils.EMPTY_DOUBLE_ARRAY : new double[n];
    }

    public ArrayDoubleList(double[] dArray) {
        if (dArray == null) {
            this.data = DoubleUtils.EMPTY_DOUBLE_ARRAY;
        } else {
            this.data = (double[])dArray.clone();
            this.size = dArray.length;
        }
    }

    public ArrayDoubleList(Collection<Double> collection) {
        if (collection == null) {
            this.data = DoubleUtils.EMPTY_DOUBLE_ARRAY;
        } else if (collection instanceof ArrayDoubleList) {
            ArrayDoubleList arrayDoubleList = (ArrayDoubleList)collection;
            this.data = new double[arrayDoubleList.size];
            System.arraycopy(arrayDoubleList.data, 0, this.data, 0, arrayDoubleList.size);
            this.size = arrayDoubleList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public double getDouble(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, double d) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = d;
        ++this.size;
        return true;
    }

    @Override
    public double removeDoubleAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        double d = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return d;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public double set(int n, double d) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        double d2 = this.data[n];
        this.data[n] = d;
        return d2;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            double[] dArray = new double[this.size];
            System.arraycopy(this.data, 0, dArray, 0, this.size);
            this.data = dArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(double d) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, double[] dArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (dArray == null || dArray.length == 0) {
            return false;
        }
        int n2 = dArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(dArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayDoubleList arrayDoubleList = (ArrayDoubleList)super.clone();
        arrayDoubleList.data = (double[])this.data.clone();
        return arrayDoubleList;
    }

    @Override
    protected void arrayCopy(int n, double[] dArray, int n2, int n3) {
        System.arraycopy(this.data, n, dArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        double[] dArray = new double[n3];
        System.arraycopy(this.data, 0, dArray, 0, n2);
        this.data = dArray;
    }
}

