/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.FloatUtils;
import org.joda.primitives.list.impl.AbstractFloatList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayFloatList
extends AbstractFloatList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private float[] data;
    private int size;

    public ArrayFloatList() {
        this.data = FloatUtils.EMPTY_FLOAT_ARRAY;
    }

    public ArrayFloatList(int n) {
        this.data = n <= 0 ? FloatUtils.EMPTY_FLOAT_ARRAY : new float[n];
    }

    public ArrayFloatList(float[] fArray) {
        if (fArray == null) {
            this.data = FloatUtils.EMPTY_FLOAT_ARRAY;
        } else {
            this.data = (float[])fArray.clone();
            this.size = fArray.length;
        }
    }

    public ArrayFloatList(Collection<Float> collection) {
        if (collection == null) {
            this.data = FloatUtils.EMPTY_FLOAT_ARRAY;
        } else if (collection instanceof ArrayFloatList) {
            ArrayFloatList arrayFloatList = (ArrayFloatList)collection;
            this.data = new float[arrayFloatList.size];
            System.arraycopy(arrayFloatList.data, 0, this.data, 0, arrayFloatList.size);
            this.size = arrayFloatList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public float getFloat(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, float f) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = f;
        ++this.size;
        return true;
    }

    @Override
    public float removeFloatAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        float f = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return f;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public float set(int n, float f) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        float f2 = this.data[n];
        this.data[n] = f;
        return f2;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            float[] fArray = new float[this.size];
            System.arraycopy(this.data, 0, fArray, 0, this.size);
            this.data = fArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(float f) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != f) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, float[] fArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (fArray == null || fArray.length == 0) {
            return false;
        }
        int n2 = fArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(fArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayFloatList arrayFloatList = (ArrayFloatList)super.clone();
        arrayFloatList.data = (float[])this.data.clone();
        return arrayFloatList;
    }

    @Override
    protected void arrayCopy(int n, float[] fArray, int n2, int n3) {
        System.arraycopy(this.data, n, fArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        float[] fArray = new float[n3];
        System.arraycopy(this.data, 0, fArray, 0, n2);
        this.data = fArray;
    }
}

