/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.IntUtils;
import org.joda.primitives.list.impl.AbstractIntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayIntList
extends AbstractIntList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private int[] data;
    private int size;

    public ArrayIntList() {
        this.data = IntUtils.EMPTY_INT_ARRAY;
    }

    public ArrayIntList(int n) {
        this.data = n <= 0 ? IntUtils.EMPTY_INT_ARRAY : new int[n];
    }

    public ArrayIntList(int[] nArray) {
        if (nArray == null) {
            this.data = IntUtils.EMPTY_INT_ARRAY;
        } else {
            this.data = (int[])nArray.clone();
            this.size = nArray.length;
        }
    }

    public ArrayIntList(Collection<Integer> collection) {
        if (collection == null) {
            this.data = IntUtils.EMPTY_INT_ARRAY;
        } else if (collection instanceof ArrayIntList) {
            ArrayIntList arrayIntList = (ArrayIntList)collection;
            this.data = new int[arrayIntList.size];
            System.arraycopy(arrayIntList.data, 0, this.data, 0, arrayIntList.size);
            this.size = arrayIntList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public int getInt(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, int n2) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = n2;
        ++this.size;
        return true;
    }

    @Override
    public int removeIntAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        int n2 = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return n2;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public int set(int n, int n2) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        int n3 = this.data[n];
        this.data[n] = n2;
        return n3;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            int[] nArray = new int[this.size];
            System.arraycopy(this.data, 0, nArray, 0, this.size);
            this.data = nArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(int n) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, int[] nArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (nArray == null || nArray.length == 0) {
            return false;
        }
        int n2 = nArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(nArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayIntList arrayIntList = (ArrayIntList)super.clone();
        arrayIntList.data = (int[])this.data.clone();
        return arrayIntList;
    }

    @Override
    protected void arrayCopy(int n, int[] nArray, int n2, int n3) {
        System.arraycopy(this.data, n, nArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        int[] nArray = new int[n3];
        System.arraycopy(this.data, 0, nArray, 0, n2);
        this.data = nArray;
    }
}

