/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.LongUtils;
import org.joda.primitives.list.impl.AbstractLongList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayLongList
extends AbstractLongList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private long[] data;
    private int size;

    public ArrayLongList() {
        this.data = LongUtils.EMPTY_LONG_ARRAY;
    }

    public ArrayLongList(int n) {
        this.data = n <= 0 ? LongUtils.EMPTY_LONG_ARRAY : new long[n];
    }

    public ArrayLongList(long[] lArray) {
        if (lArray == null) {
            this.data = LongUtils.EMPTY_LONG_ARRAY;
        } else {
            this.data = (long[])lArray.clone();
            this.size = lArray.length;
        }
    }

    public ArrayLongList(Collection<Long> collection) {
        if (collection == null) {
            this.data = LongUtils.EMPTY_LONG_ARRAY;
        } else if (collection instanceof ArrayLongList) {
            ArrayLongList arrayLongList = (ArrayLongList)collection;
            this.data = new long[arrayLongList.size];
            System.arraycopy(arrayLongList.data, 0, this.data, 0, arrayLongList.size);
            this.size = arrayLongList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public long getLong(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, long l) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = l;
        ++this.size;
        return true;
    }

    @Override
    public long removeLongAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        long l = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return l;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public long set(int n, long l) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        long l2 = this.data[n];
        this.data[n] = l;
        return l2;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            long[] lArray = new long[this.size];
            System.arraycopy(this.data, 0, lArray, 0, this.size);
            this.data = lArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(long l) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, long[] lArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (lArray == null || lArray.length == 0) {
            return false;
        }
        int n2 = lArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(lArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayLongList arrayLongList = (ArrayLongList)super.clone();
        arrayLongList.data = (long[])this.data.clone();
        return arrayLongList;
    }

    @Override
    protected void arrayCopy(int n, long[] lArray, int n2, int n3) {
        System.arraycopy(this.data, n, lArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        long[] lArray = new long[n3];
        System.arraycopy(this.data, 0, lArray, 0, n2);
        this.data = lArray;
    }
}

