/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.ShortUtils;
import org.joda.primitives.list.impl.AbstractShortList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArrayShortList
extends AbstractShortList
implements Cloneable {
    private static final int MIN_GROWTH_SIZE = 4;
    private static final int GROWTH_FACTOR_MULTIPLIER = 3;
    private static final int GROWTH_FACTOR_DIVISOR = 2;
    private short[] data;
    private int size;

    public ArrayShortList() {
        this.data = ShortUtils.EMPTY_SHORT_ARRAY;
    }

    public ArrayShortList(int n) {
        this.data = n <= 0 ? ShortUtils.EMPTY_SHORT_ARRAY : new short[n];
    }

    public ArrayShortList(short[] sArray) {
        if (sArray == null) {
            this.data = ShortUtils.EMPTY_SHORT_ARRAY;
        } else {
            this.data = (short[])sArray.clone();
            this.size = sArray.length;
        }
    }

    public ArrayShortList(Collection<Short> collection) {
        if (collection == null) {
            this.data = ShortUtils.EMPTY_SHORT_ARRAY;
        } else if (collection instanceof ArrayShortList) {
            ArrayShortList arrayShortList = (ArrayShortList)collection;
            this.data = new short[arrayShortList.size];
            System.arraycopy(arrayShortList.data, 0, this.data, 0, arrayShortList.size);
            this.size = arrayShortList.size;
        } else {
            this.data = this.toPrimitiveArray(collection);
            this.size = collection.size();
        }
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public short getShort(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean add(int n, short s) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.ensureCapacity(this.size + 1);
        System.arraycopy(this.data, n, this.data, n + 1, this.size - n);
        this.data[n] = s;
        ++this.size;
        return true;
    }

    @Override
    public short removeShortAt(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        short s = this.data[n];
        System.arraycopy(this.data, n + 1, this.data, n, this.size - 1 - n);
        --this.size;
        return s;
    }

    @Override
    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        System.arraycopy(this.data, n2, this.data, n, this.size - n2);
        this.size -= n2 - n;
        return true;
    }

    @Override
    public short set(int n, short s) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        short s2 = this.data[n];
        this.data[n] = s;
        return s2;
    }

    @Override
    public void optimize() {
        if (this.size < this.data.length) {
            short[] sArray = new short[this.size];
            System.arraycopy(this.data, 0, sArray, 0, this.size);
            this.data = sArray;
        }
    }

    @Override
    public void clear() {
        this.size = 0;
    }

    @Override
    public boolean contains(short s) {
        for (int i = 0; i < this.size; ++i) {
            if (this.data[i] != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean addAll(int n, short[] sArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (sArray == null || sArray.length == 0) {
            return false;
        }
        int n2 = sArray.length;
        this.ensureCapacity(this.size + n2);
        System.arraycopy(this.data, n, this.data, n + n2, this.size - n);
        System.arraycopy(sArray, 0, this.data, n, n2);
        this.size += n2;
        return true;
    }

    @Override
    protected boolean isAddModifiable() {
        return true;
    }

    @Override
    protected boolean isRemoveModifiable() {
        return true;
    }

    @Override
    protected boolean isSetModifiable() {
        return true;
    }

    @Override
    public boolean isModifiable() {
        return true;
    }

    @Override
    public Object clone() {
        ArrayShortList arrayShortList = (ArrayShortList)super.clone();
        arrayShortList.data = (short[])this.data.clone();
        return arrayShortList;
    }

    @Override
    protected void arrayCopy(int n, short[] sArray, int n2, int n3) {
        System.arraycopy(this.data, n, sArray, n2, n3);
    }

    protected void ensureCapacity(int n) {
        int n2 = this.data.length;
        if (n <= n2) {
            return;
        }
        int n3 = n2 * 3 / 2;
        if (n3 < n) {
            n3 = n;
        }
        if (n3 < 4) {
            n3 = 4;
        }
        short[] sArray = new short[n3];
        System.arraycopy(this.data, 0, sArray, 0, n2);
        this.data = sArray;
    }
}

