/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.BooleanUtils;
import org.joda.primitives.list.impl.AbstractBooleanList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayBooleanList
extends AbstractBooleanList {
    private static final ImmutableArrayBooleanList EMPTY = new ImmutableArrayBooleanList(BooleanUtils.EMPTY_BOOLEAN_ARRAY);
    private boolean[] data;

    public static ImmutableArrayBooleanList empty() {
        return EMPTY;
    }

    public static ImmutableArrayBooleanList copyOf(boolean[] blArray) {
        if (blArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayBooleanList((boolean[])blArray.clone());
    }

    public static ImmutableArrayBooleanList copyOf(Collection<Boolean> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayBooleanList) {
            return (ImmutableArrayBooleanList)collection;
        }
        return new ImmutableArrayBooleanList(BooleanUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayBooleanList(boolean[] blArray) {
        this.data = blArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public boolean getBoolean(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(boolean bl) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != bl) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, boolean[] blArray, int n2, int n3) {
        System.arraycopy(this.data, n, blArray, n2, n3);
    }
}

