/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.ByteUtils;
import org.joda.primitives.list.impl.AbstractByteList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayByteList
extends AbstractByteList {
    private static final ImmutableArrayByteList EMPTY = new ImmutableArrayByteList(ByteUtils.EMPTY_BYTE_ARRAY);
    private byte[] data;

    public static ImmutableArrayByteList empty() {
        return EMPTY;
    }

    public static ImmutableArrayByteList copyOf(byte[] byArray) {
        if (byArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayByteList((byte[])byArray.clone());
    }

    public static ImmutableArrayByteList copyOf(Collection<Byte> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayByteList) {
            return (ImmutableArrayByteList)collection;
        }
        return new ImmutableArrayByteList(ByteUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayByteList(byte[] byArray) {
        this.data = byArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public byte getByte(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(byte by) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != by) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, byte[] byArray, int n2, int n3) {
        System.arraycopy(this.data, n, byArray, n2, n3);
    }
}

