/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.CharUtils;
import org.joda.primitives.list.impl.AbstractCharList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayCharList
extends AbstractCharList {
    private static final ImmutableArrayCharList EMPTY = new ImmutableArrayCharList(CharUtils.EMPTY_CHAR_ARRAY);
    private char[] data;

    public static ImmutableArrayCharList empty() {
        return EMPTY;
    }

    public static ImmutableArrayCharList copyOf(char[] cArray) {
        if (cArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayCharList((char[])cArray.clone());
    }

    public static ImmutableArrayCharList copyOf(Collection<Character> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayCharList) {
            return (ImmutableArrayCharList)collection;
        }
        return new ImmutableArrayCharList(CharUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayCharList(char[] cArray) {
        this.data = cArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public char getChar(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(char c) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != c) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, char[] cArray, int n2, int n3) {
        System.arraycopy(this.data, n, cArray, n2, n3);
    }
}

