/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.DoubleUtils;
import org.joda.primitives.list.impl.AbstractDoubleList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayDoubleList
extends AbstractDoubleList {
    private static final ImmutableArrayDoubleList EMPTY = new ImmutableArrayDoubleList(DoubleUtils.EMPTY_DOUBLE_ARRAY);
    private double[] data;

    public static ImmutableArrayDoubleList empty() {
        return EMPTY;
    }

    public static ImmutableArrayDoubleList copyOf(double[] dArray) {
        if (dArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayDoubleList((double[])dArray.clone());
    }

    public static ImmutableArrayDoubleList copyOf(Collection<Double> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayDoubleList) {
            return (ImmutableArrayDoubleList)collection;
        }
        return new ImmutableArrayDoubleList(DoubleUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayDoubleList(double[] dArray) {
        this.data = dArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public double getDouble(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(double d) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != d) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, double[] dArray, int n2, int n3) {
        System.arraycopy(this.data, n, dArray, n2, n3);
    }
}

