/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.FloatUtils;
import org.joda.primitives.list.impl.AbstractFloatList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayFloatList
extends AbstractFloatList {
    private static final ImmutableArrayFloatList EMPTY = new ImmutableArrayFloatList(FloatUtils.EMPTY_FLOAT_ARRAY);
    private float[] data;

    public static ImmutableArrayFloatList empty() {
        return EMPTY;
    }

    public static ImmutableArrayFloatList copyOf(float[] fArray) {
        if (fArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayFloatList((float[])fArray.clone());
    }

    public static ImmutableArrayFloatList copyOf(Collection<Float> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayFloatList) {
            return (ImmutableArrayFloatList)collection;
        }
        return new ImmutableArrayFloatList(FloatUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayFloatList(float[] fArray) {
        this.data = fArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public float getFloat(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(float f) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != f) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, float[] fArray, int n2, int n3) {
        System.arraycopy(this.data, n, fArray, n2, n3);
    }
}

