/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.IntUtils;
import org.joda.primitives.list.impl.AbstractIntList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayIntList
extends AbstractIntList {
    private static final ImmutableArrayIntList EMPTY = new ImmutableArrayIntList(IntUtils.EMPTY_INT_ARRAY);
    private int[] data;

    public static ImmutableArrayIntList empty() {
        return EMPTY;
    }

    public static ImmutableArrayIntList copyOf(int[] nArray) {
        if (nArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayIntList((int[])nArray.clone());
    }

    public static ImmutableArrayIntList copyOf(Collection<Integer> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayIntList) {
            return (ImmutableArrayIntList)collection;
        }
        return new ImmutableArrayIntList(IntUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayIntList(int[] nArray) {
        this.data = nArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public int getInt(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(int n) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != n) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, int[] nArray, int n2, int n3) {
        System.arraycopy(this.data, n, nArray, n2, n3);
    }
}

