/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.LongUtils;
import org.joda.primitives.list.impl.AbstractLongList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayLongList
extends AbstractLongList {
    private static final ImmutableArrayLongList EMPTY = new ImmutableArrayLongList(LongUtils.EMPTY_LONG_ARRAY);
    private long[] data;

    public static ImmutableArrayLongList empty() {
        return EMPTY;
    }

    public static ImmutableArrayLongList copyOf(long[] lArray) {
        if (lArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayLongList((long[])lArray.clone());
    }

    public static ImmutableArrayLongList copyOf(Collection<Long> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayLongList) {
            return (ImmutableArrayLongList)collection;
        }
        return new ImmutableArrayLongList(LongUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayLongList(long[] lArray) {
        this.data = lArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public long getLong(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(long l) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != l) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, long[] lArray, int n2, int n3) {
        System.arraycopy(this.data, n, lArray, n2, n3);
    }
}

