/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import java.util.Collection;
import org.joda.primitives.ShortUtils;
import org.joda.primitives.list.impl.AbstractShortList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ImmutableArrayShortList
extends AbstractShortList {
    private static final ImmutableArrayShortList EMPTY = new ImmutableArrayShortList(ShortUtils.EMPTY_SHORT_ARRAY);
    private short[] data;

    public static ImmutableArrayShortList empty() {
        return EMPTY;
    }

    public static ImmutableArrayShortList copyOf(short[] sArray) {
        if (sArray == null) {
            return EMPTY;
        }
        return new ImmutableArrayShortList((short[])sArray.clone());
    }

    public static ImmutableArrayShortList copyOf(Collection<Short> collection) {
        if (collection == null) {
            return EMPTY;
        }
        if (collection instanceof ImmutableArrayShortList) {
            return (ImmutableArrayShortList)collection;
        }
        return new ImmutableArrayShortList(ShortUtils.toPrimitiveArray(collection));
    }

    private ImmutableArrayShortList(short[] sArray) {
        this.data = sArray;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public short getShort(int n) {
        this.checkIndexExists(n);
        return this.data[n];
    }

    @Override
    public boolean contains(short s) {
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i] != s) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object clone() {
        return this;
    }

    @Override
    protected void arrayCopy(int n, short[] sArray, int n2, int n3) {
        System.arraycopy(this.data, n, sArray, n2, n3);
    }
}

