/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import org.joda.primitives.list.CharList;
import org.joda.primitives.list.impl.AbstractCharList;

public class StringBufferCharList
extends AbstractCharList {
    protected final StringBuffer stringBuffer;

    public static StringBufferCharList decorate(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("StringBuffer must not be null");
        }
        return new StringBufferCharList(stringBuffer);
    }

    public StringBufferCharList() {
        this.stringBuffer = new StringBuffer();
    }

    public StringBufferCharList(CharList charList) {
        if (charList == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        this.stringBuffer = new StringBuffer(charList.size());
        this.stringBuffer.append(charList.toCharArray());
    }

    public StringBufferCharList(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        this.stringBuffer = new StringBuffer(string);
    }

    protected StringBufferCharList(StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            throw new IllegalArgumentException("StringBuffer must not be null");
        }
        this.stringBuffer = stringBuffer;
    }

    public char getChar(int n) {
        this.checkIndexExists(n);
        return this.stringBuffer.charAt(n);
    }

    public int size() {
        return this.stringBuffer.length();
    }

    public boolean add(int n, char c) {
        this.checkAddModifiable();
        this.checkIndex(n);
        this.stringBuffer.insert(n, c);
        return true;
    }

    public char removeIndex(int n) {
        this.checkRemoveModifiable();
        this.checkIndexExists(n);
        char c = this.stringBuffer.charAt(n);
        this.stringBuffer.deleteCharAt(n);
        return c;
    }

    public char set(int n, char c) {
        this.checkSetModifiable();
        this.checkIndexExists(n);
        char c2 = this.stringBuffer.charAt(n);
        this.stringBuffer.setCharAt(n, c);
        return c2;
    }

    protected boolean isAddModifiable() {
        return true;
    }

    protected boolean isRemoveModifiable() {
        return true;
    }

    protected boolean isSetModifiable() {
        return true;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean add(char c) {
        this.checkAddModifiable();
        this.stringBuffer.append(c);
        return true;
    }

    public boolean addAll(char[] cArray) {
        this.checkAddModifiable();
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        this.stringBuffer.append(cArray);
        return true;
    }

    public boolean addAll(int n, char[] cArray) {
        this.checkAddModifiable();
        this.checkIndex(n);
        if (cArray == null || cArray.length == 0) {
            return false;
        }
        this.stringBuffer.insert(n, cArray);
        return true;
    }

    public boolean removeRange(int n, int n2) {
        this.checkRemoveModifiable();
        this.checkRange(n, n2);
        if (n == n2) {
            return false;
        }
        this.stringBuffer.delete(n, n2);
        return true;
    }

    public String toStringContents() {
        return this.stringBuffer.substring(0, this.stringBuffer.length());
    }

    protected void arrayCopy(int n, char[] cArray, int n2, int n3) {
        this.stringBuffer.getChars(n, n + n3, cArray, n2);
    }
}

