/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.list.impl;

import org.joda.primitives.CharUtils;
import org.joda.primitives.list.CharList;
import org.joda.primitives.list.impl.AbstractCharList;

public class StringCharList
extends AbstractCharList
implements Cloneable {
    protected final String string;

    public StringCharList() {
        this.string = "";
    }

    public StringCharList(CharList charList) {
        if (charList == null) {
            throw new IllegalArgumentException("List must not be null");
        }
        this.string = new String(charList.toCharArray());
    }

    public StringCharList(String string) {
        if (string == null) {
            throw new IllegalArgumentException("String must not be null");
        }
        this.string = string;
    }

    public char getChar(int n) {
        return this.string.charAt(n);
    }

    public int size() {
        return this.string.length();
    }

    public boolean contains(char c) {
        return this.string.indexOf(c) >= 0;
    }

    public int indexOf(char c) {
        return this.string.indexOf(c);
    }

    public int indexOf(char c, int n) {
        return this.string.indexOf(c, n);
    }

    public int lastIndexOf(char c) {
        return this.string.lastIndexOf(c);
    }

    public int lastIndexOf(char c, int n) {
        return this.string.lastIndexOf(c, n);
    }

    public String toStringContents() {
        return this.string;
    }

    public char[] toCharArray() {
        if (this.size() == 0) {
            return CharUtils.EMPTY_CHAR_ARRAY;
        }
        return this.string.toCharArray();
    }

    public CharList subList(int n, int n2) {
        this.checkRange(n, n2);
        return new StringCharList(this.string.substring(n, n2));
    }
}

