/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.BooleanUtils;
import org.joda.primitives.listiterator.BooleanListIterator;

public class ArrayBooleanListIterator
implements BooleanListIterator {
    protected final boolean[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayBooleanListIterator copyOf(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayBooleanListIterator((boolean[])blArray.clone());
    }

    public ArrayBooleanListIterator(boolean[] blArray) {
        if (blArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = blArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public boolean nextBoolean() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Boolean next() {
        return BooleanUtils.toObject(this.nextBoolean());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public boolean previousBoolean() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Boolean previous() {
        return BooleanUtils.toObject(this.previousBoolean());
    }

    public void add(boolean bl) {
        throw new UnsupportedOperationException("ArrayBooleanListIterator does not support add");
    }

    public void add(Boolean bl) {
        throw new UnsupportedOperationException("ArrayBooleanListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayBooleanListIterator does not support remove");
    }

    public void set(boolean bl) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayBooleanListIterator cannot be set until next is called");
        }
        this.array[this.last] = bl;
    }

    public void set(Boolean bl) {
        this.set(BooleanUtils.toPrimitive(bl));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

