/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.ByteUtils;
import org.joda.primitives.listiterator.ByteListIterator;

public class ArrayByteListIterator
implements ByteListIterator {
    protected final byte[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayByteListIterator copyOf(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayByteListIterator((byte[])byArray.clone());
    }

    public ArrayByteListIterator(byte[] byArray) {
        if (byArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = byArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public byte nextByte() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Byte next() {
        return ByteUtils.toObject(this.nextByte());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public byte previousByte() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Byte previous() {
        return ByteUtils.toObject(this.previousByte());
    }

    public void add(byte by) {
        throw new UnsupportedOperationException("ArrayByteListIterator does not support add");
    }

    public void add(Byte by) {
        throw new UnsupportedOperationException("ArrayByteListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayByteListIterator does not support remove");
    }

    public void set(byte by) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayByteListIterator cannot be set until next is called");
        }
        this.array[this.last] = by;
    }

    public void set(Byte by) {
        this.set(ByteUtils.toPrimitive(by));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

