/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.CharUtils;
import org.joda.primitives.listiterator.CharListIterator;

public class ArrayCharListIterator
implements CharListIterator {
    protected final char[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayCharListIterator copyOf(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayCharListIterator((char[])cArray.clone());
    }

    public ArrayCharListIterator(char[] cArray) {
        if (cArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = cArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public char nextChar() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Character next() {
        return CharUtils.toObject(this.nextChar());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public char previousChar() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Character previous() {
        return CharUtils.toObject(this.previousChar());
    }

    public void add(char c) {
        throw new UnsupportedOperationException("ArrayCharListIterator does not support add");
    }

    public void add(Character c) {
        throw new UnsupportedOperationException("ArrayCharListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayCharListIterator does not support remove");
    }

    public void set(char c) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayCharListIterator cannot be set until next is called");
        }
        this.array[this.last] = c;
    }

    public void set(Character c) {
        this.set(CharUtils.toPrimitive(c));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

