/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.DoubleUtils;
import org.joda.primitives.listiterator.DoubleListIterator;

public class ArrayDoubleListIterator
implements DoubleListIterator {
    protected final double[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayDoubleListIterator copyOf(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayDoubleListIterator((double[])dArray.clone());
    }

    public ArrayDoubleListIterator(double[] dArray) {
        if (dArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = dArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public double nextDouble() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Double next() {
        return DoubleUtils.toObject(this.nextDouble());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public double previousDouble() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Double previous() {
        return DoubleUtils.toObject(this.previousDouble());
    }

    public void add(double d) {
        throw new UnsupportedOperationException("ArrayDoubleListIterator does not support add");
    }

    public void add(Double d) {
        throw new UnsupportedOperationException("ArrayDoubleListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayDoubleListIterator does not support remove");
    }

    public void set(double d) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayDoubleListIterator cannot be set until next is called");
        }
        this.array[this.last] = d;
    }

    public void set(Double d) {
        this.set(DoubleUtils.toPrimitive(d));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

