/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.FloatUtils;
import org.joda.primitives.listiterator.FloatListIterator;

public class ArrayFloatListIterator
implements FloatListIterator {
    protected final float[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayFloatListIterator copyOf(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayFloatListIterator((float[])fArray.clone());
    }

    public ArrayFloatListIterator(float[] fArray) {
        if (fArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = fArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public float nextFloat() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Float next() {
        return FloatUtils.toObject(this.nextFloat());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public float previousFloat() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Float previous() {
        return FloatUtils.toObject(this.previousFloat());
    }

    public void add(float f) {
        throw new UnsupportedOperationException("ArrayFloatListIterator does not support add");
    }

    public void add(Float f) {
        throw new UnsupportedOperationException("ArrayFloatListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayFloatListIterator does not support remove");
    }

    public void set(float f) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayFloatListIterator cannot be set until next is called");
        }
        this.array[this.last] = f;
    }

    public void set(Float f) {
        this.set(FloatUtils.toPrimitive(f));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

