/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.IntUtils;
import org.joda.primitives.listiterator.IntListIterator;

public class ArrayIntListIterator
implements IntListIterator {
    protected final int[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayIntListIterator copyOf(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayIntListIterator((int[])nArray.clone());
    }

    public ArrayIntListIterator(int[] nArray) {
        if (nArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = nArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public int nextInt() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Integer next() {
        return IntUtils.toObject(this.nextInt());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public int previousInt() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Integer previous() {
        return IntUtils.toObject(this.previousInt());
    }

    public void add(int n) {
        throw new UnsupportedOperationException("ArrayIntListIterator does not support add");
    }

    public void add(Integer n) {
        throw new UnsupportedOperationException("ArrayIntListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayIntListIterator does not support remove");
    }

    public void set(int n) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayIntListIterator cannot be set until next is called");
        }
        this.array[this.last] = n;
    }

    public void set(Integer n) {
        this.set(IntUtils.toPrimitive(n));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

