/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.LongUtils;
import org.joda.primitives.listiterator.LongListIterator;

public class ArrayLongListIterator
implements LongListIterator {
    protected final long[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayLongListIterator copyOf(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayLongListIterator((long[])lArray.clone());
    }

    public ArrayLongListIterator(long[] lArray) {
        if (lArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = lArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public long nextLong() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Long next() {
        return LongUtils.toObject(this.nextLong());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public long previousLong() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Long previous() {
        return LongUtils.toObject(this.previousLong());
    }

    public void add(long l) {
        throw new UnsupportedOperationException("ArrayLongListIterator does not support add");
    }

    public void add(Long l) {
        throw new UnsupportedOperationException("ArrayLongListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayLongListIterator does not support remove");
    }

    public void set(long l) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayLongListIterator cannot be set until next is called");
        }
        this.array[this.last] = l;
    }

    public void set(Long l) {
        this.set(LongUtils.toPrimitive(l));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

