/*
 * Decompiled with CFR 0.152.
 */
package org.joda.primitives.listiterator.impl;

import java.util.NoSuchElementException;
import org.joda.primitives.ShortUtils;
import org.joda.primitives.listiterator.ShortListIterator;

public class ArrayShortListIterator
implements ShortListIterator {
    protected final short[] array;
    protected int cursor = 0;
    protected int last = -1;

    public static ArrayShortListIterator copyOf(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        return new ArrayShortListIterator((short[])sArray.clone());
    }

    public ArrayShortListIterator(short[] sArray) {
        if (sArray == null) {
            throw new IllegalArgumentException("Array must not be null");
        }
        this.array = sArray;
    }

    public boolean isModifiable() {
        return true;
    }

    public boolean isResettable() {
        return true;
    }

    public boolean hasNext() {
        return this.cursor < this.array.length;
    }

    public int nextIndex() {
        return this.cursor;
    }

    public short nextShort() {
        if (!this.hasNext()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = this.cursor;
        return this.array[this.cursor++];
    }

    public Short next() {
        return ShortUtils.toObject(this.nextShort());
    }

    public boolean hasPrevious() {
        return this.cursor > 0;
    }

    public int previousIndex() {
        return this.cursor - 1;
    }

    public short previousShort() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException("No more elements available");
        }
        this.last = --this.cursor;
        return this.array[this.cursor];
    }

    public Short previous() {
        return ShortUtils.toObject(this.previousShort());
    }

    public void add(short s) {
        throw new UnsupportedOperationException("ArrayShortListIterator does not support add");
    }

    public void add(Short s) {
        throw new UnsupportedOperationException("ArrayShortListIterator does not support add");
    }

    public void remove() {
        throw new UnsupportedOperationException("ArrayShortListIterator does not support remove");
    }

    public void set(short s) {
        if (this.last < 0) {
            throw new IllegalStateException("ArrayShortListIterator cannot be set until next is called");
        }
        this.array[this.last] = s;
    }

    public void set(Short s) {
        this.set(ShortUtils.toPrimitive(s));
    }

    public void reset() {
        this.cursor = 0;
        this.last = -1;
    }
}

