/*
 * Decompiled with CFR 0.152.
 */
package org.joda.beans.maven;

import java.util.ArrayList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.joda.beans.gen.BeanCodeGen;

public class JodaBeansValidateMojo
extends AbstractMojo {
    private String indent;
    private String prefix;
    private Integer verbose;
    private boolean stopOnError = true;
    private String sourceDir;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.sourceDir == null) {
            throw new MojoExecutionException("Source directory must not be null");
        }
        ArrayList<String> argsList = new ArrayList<String>();
        argsList.add("-R");
        if (this.indent != null) {
            argsList.add("-indent=" + this.indent);
        }
        if (this.prefix != null) {
            argsList.add("-prefix=" + this.prefix);
        }
        if (this.verbose != null) {
            argsList.add("-verbose=" + this.verbose);
        }
        argsList.add("-nowrite");
        argsList.add(this.sourceDir);
        this.getLog().info((CharSequence)("Joda-Bean validator started, directory: " + this.sourceDir));
        BeanCodeGen gen = null;
        try {
            String[] args = argsList.toArray(new String[argsList.size()]);
            gen = BeanCodeGen.createFromArgs((String[])args);
        }
        catch (RuntimeException ex) {
            throw new MojoFailureException("Invalid Joda-Beans Mojo configuration: " + ex.getMessage(), (Throwable)ex);
        }
        int changes = 0;
        try {
            changes = gen.process();
        }
        catch (Exception ex) {
            throw new MojoFailureException("Error while running Joda-Beans generator: " + ex.getMessage(), (Throwable)ex);
        }
        if (changes > 0) {
            if (this.stopOnError) {
                throw new MojoFailureException("Some Joda-Beans need to be re-generated (" + changes + " files)");
            }
            this.getLog().info((CharSequence)("*** Joda-Bean validator found " + changes + " beans in need of generation ***"));
        } else {
            this.getLog().info((CharSequence)"Joda-Bean validator completed");
        }
    }
}

