/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import jodd.bean.BeanUtil;
import jodd.db.oom.DbOomException;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.util.ArraysUtil;
import jodd.util.ReflectUtil;
import jodd.util.StringUtil;

public class JoinHintResolver {
    public Object[] join(Object[] data, String hints) {
        if (hints == null) {
            return data;
        }
        return this.join(data, StringUtil.splitc(hints, ','));
    }

    public Object[] join(Object[] data, String[] hints) {
        if (hints == null) {
            return data;
        }
        HashMap<String, Object> context = new HashMap<String, Object>(hints.length);
        for (int i = 0; i < hints.length; ++i) {
            hints[i] = hints[i].trim();
            String hint = hints[i];
            if (hint.indexOf(46) != -1) continue;
            context.put(hint, data[i]);
        }
        if (context.size() == data.length) {
            return data;
        }
        Object[] result = new Object[context.size()];
        int count = 0;
        for (int i = 0; i < hints.length; ++i) {
            String hint = hints[i];
            int ndx = hint.indexOf(46);
            if (ndx != -1) {
                String key = hint.substring(0, ndx);
                Object value = context.get(key);
                if (value == null) {
                    throw new DbOomException("Hint value missing: " + key);
                }
                if (data[i] == null) continue;
                String hintPropertyName = hint.substring(ndx + 1);
                Class<?> hintPropertyType = BeanUtil.pojo.getPropertyType(value, hintPropertyName);
                if (hintPropertyType != null) {
                    ClassDescriptor cd = ClassIntrospector.lookup(hintPropertyType);
                    if (cd.isCollection()) {
                        try {
                            Collection collection = (Collection)BeanUtil.declared.getProperty(value, hintPropertyName);
                            if (collection == null) {
                                collection = (Collection)ReflectUtil.newInstance(hintPropertyType);
                                BeanUtil.declaredSilent.setProperty(value, hintPropertyName, collection);
                            }
                            collection.add(data[i]);
                            continue;
                        }
                        catch (Exception ex) {
                            throw new DbOomException(ex);
                        }
                    }
                    if (cd.isArray()) {
                        try {
                            Object[] array = (Object[])BeanUtil.declared.getProperty(value, hintPropertyName);
                            if (array == null) {
                                array = (Object[])Array.newInstance(hintPropertyType.getComponentType(), 1);
                                BeanUtil.declaredSilent.setProperty(value, hintPropertyName, array);
                                array[0] = data[i];
                                continue;
                            }
                            Object[] newArray = ArraysUtil.append(array, data[i]);
                            if (newArray == array) continue;
                            BeanUtil.declaredSilent.setProperty(value, hintPropertyName, newArray);
                            continue;
                        }
                        catch (Exception ex) {
                            throw new DbOomException(ex);
                        }
                    }
                    BeanUtil.declaredSilent.setProperty(value, hintPropertyName, data[i]);
                    continue;
                }
                int lastNdx = hintPropertyName.lastIndexOf(46);
                String name = hintPropertyName.substring(0, lastNdx);
                Object target = this.resolveValueInSpecialCase(value, name);
                if (target == null) continue;
                String targetSimpleName = hintPropertyName.substring(lastNdx + 1);
                BeanUtil.declaredForcedSilent.setProperty(target, targetSimpleName, data[i]);
                continue;
            }
            result[count] = data[i];
            ++count;
        }
        return result;
    }

    protected Object resolveValueInSpecialCase(Object value, String name) {
        String[] elements;
        for (String element : elements = StringUtil.splitc(name, '.')) {
            if (!((value = BeanUtil.declaredSilent.getProperty(value, element)) instanceof List)) continue;
            List list = (List)value;
            value = list.get(list.size() - 1);
        }
        return value;
    }
}

