/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.type;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.Ref;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.HashMap;
import jodd.datetime.JDateTime;
import jodd.db.DbSqlException;
import jodd.db.type.BigDecimalSqlType;
import jodd.db.type.BigIntegerSqlType;
import jodd.db.type.BlobSqlType;
import jodd.db.type.BooleanSqlType;
import jodd.db.type.ByteArraySqlType;
import jodd.db.type.ByteSqlType;
import jodd.db.type.CharacterSqlType;
import jodd.db.type.ClobSqlType;
import jodd.db.type.DateSqlType;
import jodd.db.type.DoubleSqlType;
import jodd.db.type.FloatSqlType;
import jodd.db.type.IntegerSqlType;
import jodd.db.type.JDateTimeSqlType;
import jodd.db.type.LongSqlType;
import jodd.db.type.ShortSqlType;
import jodd.db.type.SqlArraySqlType;
import jodd.db.type.SqlDateSqlType;
import jodd.db.type.SqlRefSqlType;
import jodd.db.type.SqlType;
import jodd.db.type.StringSqlType;
import jodd.db.type.TimeSqlType;
import jodd.db.type.TimestampSqlType;
import jodd.db.type.URLSqlType;
import jodd.mutable.MutableBoolean;
import jodd.mutable.MutableByte;
import jodd.mutable.MutableDouble;
import jodd.mutable.MutableFloat;
import jodd.mutable.MutableInteger;
import jodd.mutable.MutableLong;
import jodd.mutable.MutableShort;

public class SqlTypeManager {
    private static HashMap<Class, SqlType> types = new HashMap();
    private static HashMap<Class<? extends SqlType>, SqlType> sqlTypes = new HashMap();

    public static void unregisterAll() {
        types.clear();
    }

    public static void registerDefaults() {
        SqlTypeManager.register(Integer.class, IntegerSqlType.class);
        SqlTypeManager.register(Integer.TYPE, IntegerSqlType.class);
        SqlTypeManager.register(MutableInteger.class, IntegerSqlType.class);
        SqlTypeManager.register(Float.class, FloatSqlType.class);
        SqlTypeManager.register(Float.TYPE, FloatSqlType.class);
        SqlTypeManager.register(MutableFloat.class, FloatSqlType.class);
        SqlTypeManager.register(Double.class, DoubleSqlType.class);
        SqlTypeManager.register(Double.TYPE, DoubleSqlType.class);
        SqlTypeManager.register(MutableDouble.class, DoubleSqlType.class);
        SqlTypeManager.register(Byte.class, ByteSqlType.class);
        SqlTypeManager.register(Byte.TYPE, ByteSqlType.class);
        SqlTypeManager.register(MutableByte.class, ByteSqlType.class);
        SqlTypeManager.register(Boolean.class, BooleanSqlType.class);
        SqlTypeManager.register(Boolean.TYPE, BooleanSqlType.class);
        SqlTypeManager.register(MutableBoolean.class, BooleanSqlType.class);
        SqlTypeManager.register(Long.class, LongSqlType.class);
        SqlTypeManager.register(Long.TYPE, LongSqlType.class);
        SqlTypeManager.register(MutableLong.class, LongSqlType.class);
        SqlTypeManager.register(Short.class, ShortSqlType.class);
        SqlTypeManager.register(Short.TYPE, ShortSqlType.class);
        SqlTypeManager.register(MutableShort.class, ShortSqlType.class);
        SqlTypeManager.register(Character.class, CharacterSqlType.class);
        SqlTypeManager.register(Character.TYPE, CharacterSqlType.class);
        SqlTypeManager.register(BigDecimal.class, BigDecimalSqlType.class);
        SqlTypeManager.register(BigInteger.class, BigIntegerSqlType.class);
        SqlTypeManager.register(String.class, StringSqlType.class);
        SqlTypeManager.register(Date.class, SqlDateSqlType.class);
        SqlTypeManager.register(Timestamp.class, TimestampSqlType.class);
        SqlTypeManager.register(Time.class, TimeSqlType.class);
        SqlTypeManager.register(java.util.Date.class, DateSqlType.class);
        SqlTypeManager.register(JDateTime.class, JDateTimeSqlType.class);
        SqlTypeManager.register(byte[].class, ByteArraySqlType.class);
        SqlTypeManager.register(URL.class, URLSqlType.class);
        SqlTypeManager.register(Blob.class, BlobSqlType.class);
        SqlTypeManager.register(Clob.class, ClobSqlType.class);
        SqlTypeManager.register(Array.class, SqlArraySqlType.class);
        SqlTypeManager.register(Ref.class, SqlRefSqlType.class);
    }

    public static void register(Class type, Class<? extends SqlType> sqlTypeClass) {
        types.put(type, SqlTypeManager.lookupSqlType(sqlTypeClass));
    }

    public static void unregister(Class type) {
        types.remove(type);
    }

    public static SqlType lookup(Class clazz) {
        for (Class x = clazz; x != null; x = x.getSuperclass()) {
            Class<?>[] interfaces;
            SqlType sqlType = types.get(clazz);
            if (sqlType != null) {
                return sqlType;
            }
            for (Class<?> i : interfaces = x.getInterfaces()) {
                sqlType = types.get(i);
                if (sqlType == null) continue;
                return sqlType;
            }
        }
        return null;
    }

    public static SqlType lookupSqlType(Class<? extends SqlType> sqlTypeClass) {
        SqlType sqlType = sqlTypes.get(sqlTypeClass);
        if (sqlType == null) {
            try {
                sqlType = sqlTypeClass.newInstance();
            }
            catch (Exception ex) {
                throw new DbSqlException("SQL type not found: " + sqlTypeClass.getSimpleName(), ex);
            }
            sqlTypes.put(sqlTypeClass, sqlType);
        }
        return sqlType;
    }

    static {
        SqlTypeManager.registerDefaults();
    }
}

