/*
 * Decompiled with CFR 0.152.
 */
package jodd.jtx.proxy;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import jodd.jtx.JtxTransactionManager;
import jodd.jtx.JtxTransactionMode;
import jodd.jtx.meta.Transaction;
import jodd.jtx.meta.TransactionAnnotation;
import jodd.jtx.meta.TransactionAnnotationData;
import jodd.jtx.worker.LeanJtxWorker;
import jodd.proxetta.ProxettaException;
import jodd.util.AnnotationDataReader;
import jodd.util.StringUtil;

public class AnnotationTxAdviceManager {
    protected static final String JTXCTX_PATTERN_CLASS = "$class";
    protected static final String JTXCTX_PATTERN_METHOD = "$method";
    protected final Map<String, JtxTransactionMode> txmap = new HashMap<String, JtxTransactionMode>();
    protected final LeanJtxWorker jtxWorker;
    protected final JtxTransactionMode defaultTransactionMode;
    protected final String scopePattern;
    protected Class<? extends Annotation>[] annotations;
    protected TransactionAnnotation[] annotationInstances;

    public AnnotationTxAdviceManager(JtxTransactionManager jtxManager) {
        this(new LeanJtxWorker(jtxManager));
    }

    public AnnotationTxAdviceManager(LeanJtxWorker jtxWorker) {
        this(jtxWorker, "$class#$method", null);
    }

    public AnnotationTxAdviceManager(JtxTransactionManager jtxManager, String scopePattern) {
        this(new LeanJtxWorker(jtxManager), scopePattern);
    }

    public AnnotationTxAdviceManager(LeanJtxWorker jtxWorker, String scopePattern) {
        this(jtxWorker, scopePattern, null);
    }

    public AnnotationTxAdviceManager(JtxTransactionManager jtxManager, String scopePattern, JtxTransactionMode defaultTxMode) {
        this(new LeanJtxWorker(jtxManager), scopePattern, defaultTxMode);
    }

    public AnnotationTxAdviceManager(LeanJtxWorker jtxWorker, String scopePattern, JtxTransactionMode defaultTxMode) {
        this.jtxWorker = jtxWorker;
        this.defaultTransactionMode = defaultTxMode == null ? new JtxTransactionMode().propagationSupports() : defaultTxMode;
        this.scopePattern = scopePattern;
        this.registerAnnotations(Transaction.class);
    }

    public LeanJtxWorker getJtxWorker() {
        return this.jtxWorker;
    }

    public JtxTransactionMode getDefaultTransactionMode() {
        return this.defaultTransactionMode;
    }

    public String resolveScope(Class type, String methodName) {
        if (this.scopePattern == null) {
            return null;
        }
        String ctx = this.scopePattern;
        ctx = StringUtil.replace(ctx, JTXCTX_PATTERN_CLASS, type.getName());
        ctx = StringUtil.replace(ctx, JTXCTX_PATTERN_METHOD, methodName);
        return ctx;
    }

    public synchronized JtxTransactionMode getTxMode(Class type, String methodName, Class[] methodArgTypes, String unique) {
        String signature = type.getName() + '#' + methodName + '%' + unique;
        JtxTransactionMode txMode = this.txmap.get(signature);
        if (txMode == null && !this.txmap.containsKey(signature)) {
            Method m;
            try {
                m = type.getMethod(methodName, methodArgTypes);
            }
            catch (NoSuchMethodException nsmex) {
                throw new ProxettaException(nsmex);
            }
            TransactionAnnotationData txAnn = this.getTransactionAnnotation(m);
            if (txAnn != null) {
                txMode = new JtxTransactionMode();
                txMode.setPropagationBehaviour(txAnn.getPropagation());
                txMode.setIsolationLevel(txAnn.getIsolation());
                txMode.setReadOnly(txAnn.isReadOnly());
                txMode.setTransactionTimeout(txAnn.getTimeout());
            } else {
                txMode = this.defaultTransactionMode;
            }
            this.txmap.put(signature, txMode);
        }
        return txMode;
    }

    public void registerAnnotations(Class<? extends Annotation> ... txAnnotations) {
        this.annotations = txAnnotations;
        this.annotationInstances = new TransactionAnnotation[this.annotations.length];
        for (int i = 0; i < this.annotations.length; ++i) {
            Class<? extends Annotation> annotationClass = this.annotations[i];
            this.annotationInstances[i] = new TransactionAnnotation<Annotation>(annotationClass);
        }
    }

    protected TransactionAnnotationData getTransactionAnnotation(Method method) {
        for (TransactionAnnotation annotationInstance : this.annotationInstances) {
            AnnotationDataReader.AnnotationData tad = annotationInstance.readAnnotationData(method);
            if (tad == null) continue;
            return tad;
        }
        return null;
    }
}

