/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.injector;

import java.util.Enumeration;
import javax.servlet.ServletContext;
import jodd.madvoc.ActionRequest;
import jodd.madvoc.ScopeData;
import jodd.madvoc.ScopeType;
import jodd.madvoc.component.ScopeDataResolver;
import jodd.madvoc.injector.BaseScopeInjector;
import jodd.madvoc.injector.ContextInjector;
import jodd.madvoc.injector.Injector;
import jodd.madvoc.injector.Outjector;
import jodd.madvoc.injector.Target;

public class ApplicationScopeInjector
extends BaseScopeInjector
implements Injector,
Outjector,
ContextInjector<ServletContext> {
    public ApplicationScopeInjector(ScopeDataResolver scopeDataResolver) {
        super(ScopeType.APPLICATION, scopeDataResolver);
        this.silent = true;
    }

    @Override
    public void inject(ActionRequest actionRequest) {
        Target[] targets = actionRequest.getTargets();
        ScopeData[] injectData = this.lookupScopeData(actionRequest);
        if (injectData == null) {
            return;
        }
        ServletContext servletContext = actionRequest.getHttpServletRequest().getSession().getServletContext();
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            for (int i = 0; i < targets.length; ++i) {
                ScopeData.In[] scopes;
                Target target = targets[i];
                if (injectData[i] == null || (scopes = injectData[i].in) == null) continue;
                for (ScopeData.In in : scopes) {
                    String name = this.getMatchedPropertyName(in, attrName);
                    if (name == null) continue;
                    Object attrValue = servletContext.getAttribute(attrName);
                    this.setTargetProperty(target, name, attrValue);
                }
            }
        }
    }

    @Override
    public void injectContext(Target target, ScopeData[] scopeData, ServletContext servletContext) {
        ScopeData.In[] injectData = this.lookupInData(scopeData);
        if (injectData == null) {
            return;
        }
        Enumeration attributeNames = servletContext.getAttributeNames();
        while (attributeNames.hasMoreElements()) {
            String attrName = (String)attributeNames.nextElement();
            for (ScopeData.In in : injectData) {
                String name = this.getMatchedPropertyName(in, attrName);
                if (name == null) continue;
                Object attrValue = servletContext.getAttribute(attrName);
                this.setTargetProperty(target, name, attrValue);
            }
        }
    }

    @Override
    public void outject(ActionRequest actionRequest) {
        ScopeData[] outjectData = this.lookupScopeData(actionRequest);
        if (outjectData == null) {
            return;
        }
        Target[] targets = actionRequest.getTargets();
        ServletContext context = actionRequest.getHttpServletRequest().getSession().getServletContext();
        for (int i = 0; i < targets.length; ++i) {
            ScopeData.Out[] scopes;
            Target target = targets[i];
            if (outjectData[i] == null || (scopes = outjectData[i].out) == null) continue;
            for (ScopeData.Out out : scopes) {
                Object value = this.getTargetProperty(target, out);
                context.setAttribute(out.name, value);
            }
        }
    }
}

