/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.CtorDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.BeanDefinition;
import jodd.petite.DestroyMethodPoint;
import jodd.petite.InitMethodPoint;
import jodd.petite.InjectionPointFactory;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.ParamManager;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteContainer;
import jodd.petite.PetiteException;
import jodd.petite.PetiteResolvers;
import jodd.petite.PetiteUtil;
import jodd.petite.PropertyInjectionPoint;
import jodd.petite.ProviderDefinition;
import jodd.petite.SetInjectionPoint;
import jodd.petite.WiringMode;
import jodd.petite.meta.InitMethodInvocationStrategy;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;
import jodd.props.Props;
import jodd.util.ReflectUtil;
import jodd.util.StringPool;

public abstract class PetiteBeans {
    private static final Logger log = LoggerFactory.getLogger(PetiteBeans.class);
    protected final Map<String, BeanDefinition> beans = new HashMap<String, BeanDefinition>();
    protected final Map<String, BeanDefinition> beansAlt = new HashMap<String, BeanDefinition>();
    protected final Map<Class<? extends Scope>, Scope> scopes = new HashMap<Class<? extends Scope>, Scope>();
    protected final Map<String, ProviderDefinition> providers = new HashMap<String, ProviderDefinition>();
    protected final Map<Class, String[]> beanCollections = new HashMap<Class, String[]>();
    protected final PetiteConfig petiteConfig;
    protected final InjectionPointFactory injectionPointFactory;
    protected final PetiteResolvers petiteResolvers;
    protected final ParamManager paramManager;

    protected PetiteBeans(PetiteConfig petiteConfig) {
        this.petiteConfig = petiteConfig;
        this.injectionPointFactory = new InjectionPointFactory(petiteConfig);
        this.petiteResolvers = new PetiteResolvers(this.injectionPointFactory);
        this.paramManager = new ParamManager();
    }

    public ParamManager getParamManager() {
        return this.paramManager;
    }

    public PetiteConfig getConfig() {
        return this.petiteConfig;
    }

    public <S extends Scope> S resolveScope(Class<S> scopeType) {
        Scope scope = this.scopes.get(scopeType);
        if (scope == null) {
            try {
                scope = (Scope)PetiteUtil.newInstance(scopeType, (PetiteContainer)this);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid Petite scope: " + scopeType.getName(), ex);
            }
            this.registerScope(scopeType, scope);
            this.scopes.put(scopeType, scope);
        }
        return (S)scope;
    }

    public void registerScope(Class<? extends Scope> scopeType, Scope scope) {
        this.scopes.put(scopeType, scope);
    }

    public BeanDefinition lookupBeanDefinition(String name) {
        BeanDefinition beanDefinition = this.beans.get(name);
        if (beanDefinition == null && this.petiteConfig.isUseAltBeanNames()) {
            beanDefinition = this.beansAlt.get(name);
        }
        return beanDefinition;
    }

    protected BeanDefinition lookupBeanDefinitions(String ... names) {
        for (String name : names) {
            BeanDefinition beanDefinition = this.lookupBeanDefinition(name);
            if (beanDefinition == null) continue;
            return beanDefinition;
        }
        return null;
    }

    protected BeanDefinition lookupExistingBeanDefinition(String name) {
        BeanDefinition beanDefinition = this.lookupBeanDefinition(name);
        if (beanDefinition == null) {
            throw new PetiteException("Bean not found: " + name);
        }
        return beanDefinition;
    }

    public boolean isBeanNameRegistered(String name) {
        return this.lookupBeanDefinition(name) != null;
    }

    public String resolveBeanName(Class type) {
        return PetiteUtil.resolveBeanName(type, this.petiteConfig.getUseFullTypeNames());
    }

    protected BeanDefinition createBeanDefinitionForRegistration(String name, Class type, Scope scope, WiringMode wiringMode) {
        return new BeanDefinition(name, type, scope, wiringMode);
    }

    public BeanDefinition registerPetiteBean(Class type) {
        return this.registerPetiteBean(type, null, null, null, false);
    }

    public BeanDefinition registerPetiteBean(Class type, String name, Class<? extends Scope> scopeType, WiringMode wiringMode, boolean define) {
        BeanDefinition existing;
        if (name == null) {
            name = this.resolveBeanName(type);
        }
        if (wiringMode == null) {
            wiringMode = PetiteUtil.resolveBeanWiringMode(type);
        }
        if (wiringMode == WiringMode.DEFAULT) {
            wiringMode = this.petiteConfig.getDefaultWiringMode();
        }
        if (scopeType == null) {
            scopeType = PetiteUtil.resolveBeanScopeType(type);
        }
        if (scopeType == null) {
            scopeType = SingletonScope.class;
        }
        if ((existing = this.removeBean(name)) != null && this.petiteConfig.getDetectDuplicatedBeanNames()) {
            throw new PetiteException("Duplicated bean name detected while registering class '" + type.getName() + "'. Petite bean class '" + existing.type.getName() + "' is already registered with the name: " + name);
        }
        if (type.isInterface()) {
            throw new PetiteException("PetiteBean can not be an interface: " + type.getName());
        }
        if (log.isDebugEnabled()) {
            log.debug("Register bean " + name + " of type " + type.getSimpleName() + " in " + scopeType.getSimpleName() + " using wiring mode " + wiringMode.toString());
        }
        Scope scope = this.resolveScope(scopeType);
        BeanDefinition beanDefinition = this.createBeanDefinitionForRegistration(name, type, scope, wiringMode);
        this.registerBean(name, beanDefinition);
        ProviderDefinition[] providerDefinitions = this.petiteResolvers.resolveProviderDefinitions(beanDefinition);
        if (providerDefinitions != null) {
            for (ProviderDefinition providerDefinition : providerDefinitions) {
                this.providers.put(providerDefinition.name, providerDefinition);
            }
        }
        if (define) {
            beanDefinition.ctor = this.petiteResolvers.resolveCtorInjectionPoint(beanDefinition.getType());
            beanDefinition.properties = PropertyInjectionPoint.EMPTY;
            beanDefinition.methods = MethodInjectionPoint.EMPTY;
            beanDefinition.initMethods = InitMethodPoint.EMPTY;
            beanDefinition.destroyMethods = DestroyMethodPoint.EMPTY;
        }
        return beanDefinition;
    }

    protected void registerBean(String name, BeanDefinition beanDefinition) {
        Class[] interfaces;
        this.beans.put(name, beanDefinition);
        if (!this.petiteConfig.isUseAltBeanNames()) {
            return;
        }
        Class type = beanDefinition.getType();
        if (PetiteUtil.beanHasAnnotationName(type)) {
            return;
        }
        for (Class anInterface : interfaces = ReflectUtil.resolveAllInterfaces(type)) {
            String altName = PetiteUtil.resolveBeanName(anInterface, this.petiteConfig.getUseFullTypeNames());
            if (name.equals(altName) || this.beans.containsKey(altName)) continue;
            if (this.beansAlt.containsKey(altName)) {
                BeanDefinition existing = this.beansAlt.get(altName);
                if (existing == null) continue;
                this.beansAlt.put(altName, null);
                continue;
            }
            this.beansAlt.put(altName, beanDefinition);
        }
    }

    public void removeBean(Class type) {
        HashSet<String> beanNames = new HashSet<String>();
        for (BeanDefinition def : this.beans.values()) {
            if (!def.type.equals(type)) continue;
            beanNames.add(def.name);
        }
        for (String beanName : beanNames) {
            this.removeBean(beanName);
        }
    }

    public BeanDefinition removeBean(String name) {
        BeanDefinition bd = this.beans.remove(name);
        if (bd == null) {
            return null;
        }
        bd.scopeRemove();
        return bd;
    }

    protected String[] resolveBeanNamesForType(Class type) {
        String[] beanNames = this.beanCollections.get(type);
        if (beanNames != null) {
            return beanNames;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Map.Entry<String, BeanDefinition> entry : this.beans.entrySet()) {
            BeanDefinition beanDefinition = entry.getValue();
            if (!ReflectUtil.isTypeOf(beanDefinition.type, type)) continue;
            String beanName = entry.getKey();
            list.add(beanName);
        }
        beanNames = list.isEmpty() ? StringPool.EMPTY_ARRAY : list.toArray(new String[list.size()]);
        this.beanCollections.put(type, beanNames);
        return beanNames;
    }

    public void registerPetiteCtorInjectionPoint(String beanName, Class[] paramTypes, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        String[][] ref = PetiteUtil.convertRefToReferences(references);
        ClassDescriptor cd = ClassIntrospector.lookup(beanDefinition.type);
        Constructor constructor = null;
        if (paramTypes == null) {
            CtorDescriptor[] ctors = cd.getAllCtorDescriptors();
            if (ctors != null && ctors.length > 0) {
                if (ctors.length > 1) {
                    throw new PetiteException(ctors.length + " suitable constructor found as injection point for: " + beanDefinition.type.getName());
                }
                constructor = ctors[0].getConstructor();
            }
        } else {
            CtorDescriptor ctorDescriptor = cd.getCtorDescriptor(paramTypes, true);
            if (ctorDescriptor != null) {
                constructor = ctorDescriptor.getConstructor();
            }
        }
        if (constructor == null) {
            throw new PetiteException("Constructor not found: " + beanDefinition.type.getName());
        }
        beanDefinition.ctor = this.injectionPointFactory.createCtorInjectionPoint(constructor, ref);
    }

    public void registerPetitePropertyInjectionPoint(String beanName, String property, String reference) {
        String[] stringArray;
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        if (reference == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = reference;
        }
        String[] references = stringArray;
        ClassDescriptor cd = ClassIntrospector.lookup(beanDefinition.type);
        PropertyDescriptor propertyDescriptor = cd.getPropertyDescriptor(property, true);
        if (propertyDescriptor == null) {
            throw new PetiteException("Property not found: " + beanDefinition.type.getName() + '#' + property);
        }
        PropertyInjectionPoint pip = this.injectionPointFactory.createPropertyInjectionPoint(propertyDescriptor, references);
        beanDefinition.addPropertyInjectionPoint(pip);
    }

    public void registerPetiteSetInjectionPoint(String beanName, String property) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.lookup(beanDefinition.type);
        PropertyDescriptor propertyDescriptor = cd.getPropertyDescriptor(property, true);
        if (propertyDescriptor == null) {
            throw new PetiteException("Property not found: " + beanDefinition.type.getName() + '#' + property);
        }
        SetInjectionPoint sip = this.injectionPointFactory.createSetInjectionPoint(propertyDescriptor);
        beanDefinition.addSetInjectionPoint(sip);
    }

    public void registerPetiteMethodInjectionPoint(String beanName, String methodName, Class[] arguments, String[] references) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        String[][] ref = PetiteUtil.convertRefToReferences(references);
        ClassDescriptor cd = ClassIntrospector.lookup(beanDefinition.type);
        Method method = null;
        if (arguments == null) {
            MethodDescriptor[] methods = cd.getAllMethodDescriptors(methodName);
            if (methods != null && methods.length > 0) {
                if (methods.length > 1) {
                    throw new PetiteException(methods.length + " suitable methods found as injection points for: " + beanDefinition.type.getName() + '#' + methodName);
                }
                method = methods[0].getMethod();
            }
        } else {
            MethodDescriptor md = cd.getMethodDescriptor(methodName, arguments, true);
            if (md != null) {
                method = md.getMethod();
            }
        }
        if (method == null) {
            throw new PetiteException("Method not found: " + beanDefinition.type.getName() + '#' + methodName);
        }
        MethodInjectionPoint mip = this.injectionPointFactory.createMethodInjectionPoint(method, ref);
        beanDefinition.addMethodInjectionPoint(mip);
    }

    public void registerPetiteInitMethods(String beanName, InitMethodInvocationStrategy invocationStrategy, String ... initMethodNames) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.lookup(beanDefinition.type);
        if (initMethodNames == null) {
            initMethodNames = StringPool.EMPTY_ARRAY;
        }
        int total = initMethodNames.length;
        InitMethodPoint[] initMethodPoints = new InitMethodPoint[total];
        for (int i = 0; i < initMethodNames.length; ++i) {
            MethodDescriptor md = cd.getMethodDescriptor(initMethodNames[i], ReflectUtil.NO_PARAMETERS, true);
            if (md == null) {
                throw new PetiteException("Init method not found: " + beanDefinition.type.getName() + '#' + initMethodNames[i]);
            }
            initMethodPoints[i] = new InitMethodPoint(md.getMethod(), i, invocationStrategy);
        }
        beanDefinition.addInitMethodPoints(initMethodPoints);
    }

    public void registerPetiteDestroyMethods(String beanName, String ... destroyMethodNames) {
        BeanDefinition beanDefinition = this.lookupExistingBeanDefinition(beanName);
        ClassDescriptor cd = ClassIntrospector.lookup(beanDefinition.type);
        if (destroyMethodNames == null) {
            destroyMethodNames = StringPool.EMPTY_ARRAY;
        }
        int total = destroyMethodNames.length;
        DestroyMethodPoint[] destroyMethodPoints = new DestroyMethodPoint[total];
        for (int i = 0; i < destroyMethodNames.length; ++i) {
            MethodDescriptor md = cd.getMethodDescriptor(destroyMethodNames[i], ReflectUtil.NO_PARAMETERS, true);
            if (md == null) {
                throw new PetiteException("Destroy method not found: " + beanDefinition.type.getName() + '#' + destroyMethodNames[i]);
            }
            destroyMethodPoints[i] = new DestroyMethodPoint(md.getMethod());
        }
        beanDefinition.addDestroyMethodPoints(destroyMethodPoints);
    }

    public void registerPetiteProvider(String providerName, String beanName, String methodName, Class[] arguments) {
        BeanDefinition beanDefinition = this.lookupBeanDefinition(beanName);
        if (beanDefinition == null) {
            throw new PetiteException("Bean not found: " + beanName);
        }
        Class beanType = beanDefinition.type;
        ClassDescriptor cd = ClassIntrospector.lookup(beanType);
        MethodDescriptor md = cd.getMethodDescriptor(methodName, arguments, true);
        if (md == null) {
            throw new PetiteException("Provider method not found: " + methodName);
        }
        ProviderDefinition providerDefinition = new ProviderDefinition(providerName, beanName, md.getMethod());
        this.providers.put(providerName, providerDefinition);
    }

    public void registerPetiteProvider(String providerName, Class type, String staticMethodName, Class[] arguments) {
        ClassDescriptor cd = ClassIntrospector.lookup(type);
        MethodDescriptor md = cd.getMethodDescriptor(staticMethodName, arguments, true);
        if (md == null) {
            throw new PetiteException("Provider method not found: " + staticMethodName);
        }
        ProviderDefinition providerDefinition = new ProviderDefinition(providerName, md.getMethod());
        this.providers.put(providerName, providerDefinition);
    }

    public int getTotalBeans() {
        return this.beans.size();
    }

    public int getTotalScopes() {
        return this.scopes.size();
    }

    public Set<String> getBeanNames() {
        return this.beans.keySet();
    }

    public void defineParameter(String name, Object value) {
        this.paramManager.put(name, value);
    }

    public Object getParameter(String name) {
        return this.paramManager.get(name);
    }

    protected String[] resolveBeanParams(String name, boolean resolveReferenceParams) {
        return this.paramManager.resolve(name, resolveReferenceParams);
    }

    public void defineParameters(Map<?, ?> properties) {
        for (Map.Entry<?, ?> entry : properties.entrySet()) {
            this.defineParameter(entry.getKey().toString(), entry.getValue());
        }
    }

    public void defineParameters(Props props) {
        HashMap map = new HashMap();
        props.extractProps(map);
        this.defineParameters(map);
    }
}

