/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.lang.reflect.Method;
import java.util.ArrayList;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.MethodDescriptor;
import jodd.petite.InjectionPointFactory;
import jodd.petite.MethodInjectionPoint;
import jodd.petite.PetiteUtil;
import jodd.petite.meta.PetiteInject;
import jodd.util.ReflectUtil;

public class MethodResolver {
    protected final InjectionPointFactory injectionPointFactory;

    public MethodResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public MethodInjectionPoint[] resolve(Class type) {
        MethodDescriptor[] allMethods;
        ClassDescriptor cd = ClassIntrospector.lookup(type);
        ArrayList<MethodInjectionPoint> list = new ArrayList<MethodInjectionPoint>();
        for (MethodDescriptor methodDescriptor : allMethods = cd.getAllMethodDescriptors()) {
            PetiteInject ref;
            Method method = methodDescriptor.getMethod();
            if (ReflectUtil.isBeanPropertySetter(method) || method.getParameterTypes().length == 0 || (ref = method.getAnnotation(PetiteInject.class)) == null) continue;
            String[][] references = PetiteUtil.convertAnnValueToReferences(ref.value());
            list.add(this.injectionPointFactory.createMethodInjectionPoint(method, references));
        }
        MethodInjectionPoint[] methods = list.isEmpty() ? MethodInjectionPoint.EMPTY : list.toArray(new MethodInjectionPoint[list.size()]);
        return methods;
    }
}

