/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite.resolver;

import java.util.ArrayList;
import java.util.Collection;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.introspector.FieldDescriptor;
import jodd.introspector.MethodDescriptor;
import jodd.introspector.PropertyDescriptor;
import jodd.petite.InjectionPointFactory;
import jodd.petite.SetInjectionPoint;
import jodd.petite.meta.PetiteInject;
import jodd.util.ReflectUtil;

public class SetResolver {
    protected final InjectionPointFactory injectionPointFactory;

    public SetResolver(InjectionPointFactory injectionPointFactory) {
        this.injectionPointFactory = injectionPointFactory;
    }

    public SetInjectionPoint[] resolve(Class type, boolean autowire) {
        PropertyDescriptor[] allProperties;
        ClassDescriptor cd = ClassIntrospector.lookup(type);
        ArrayList<SetInjectionPoint> list = new ArrayList<SetInjectionPoint>();
        for (PropertyDescriptor propertyDescriptor : allProperties = cd.getAllPropertyDescriptors()) {
            Class propertyType;
            if (propertyDescriptor.isGetterOnly() || !ReflectUtil.isTypeOf(propertyType = propertyDescriptor.getType(), Collection.class)) continue;
            MethodDescriptor writeMethodDescriptor = propertyDescriptor.getWriteMethodDescriptor();
            FieldDescriptor fieldDescriptor = propertyDescriptor.getFieldDescriptor();
            PetiteInject ref = null;
            if (writeMethodDescriptor != null) {
                ref = writeMethodDescriptor.getMethod().getAnnotation(PetiteInject.class);
            }
            if (ref == null && fieldDescriptor != null) {
                ref = fieldDescriptor.getField().getAnnotation(PetiteInject.class);
            }
            if (!autowire && ref == null) continue;
            list.add(this.injectionPointFactory.createSetInjectionPoint(propertyDescriptor));
        }
        SetInjectionPoint[] fields = list.isEmpty() ? SetInjectionPoint.EMPTY : list.toArray(new SetInjectionPoint[list.size()]);
        return fields;
    }
}

