/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly;

import java.io.IOException;
import java.nio.CharBuffer;
import java.util.ArrayList;
import jodd.csselly.CSSellyException;
import jodd.csselly.Combinator;
import jodd.csselly.CssSelector;

final class CSSellyLexer {
    public static final int YYEOF = -1;
    private static final int ZZ_BUFFERSIZE = 4096;
    public static final int YYINITIAL = 0;
    public static final int SELECTOR = 2;
    public static final int ATTR = 4;
    public static final int COMBINATOR = 6;
    public static final int PSEUDO_FN = 8;
    private static final int[] ZZ_LEXSTATE = new int[]{0, 0, 1, 1, 2, 2, 3, 3, 4, 4};
    private static final String ZZ_CMAP_PACKED = "\t\u0002\u0001\b\u0001\u0007\u0001\u000e\u0001\t\u0001\u0006\u0012\u0002\u0001\b\u0001\u0002\u0001\u000b\u0001\u0011\u0001\u0016\u0002\u0002\u0001\f\u0001\u0013\u0001\u001a\u0001\r\u0001\u0019\u0001\u0002\u0001\u0001\u0001\n\u0001\u0002\n\u0005\u0001\u0012\u0002\u0002\u0001\u0014\u0001\u0018\u0002\u0002\u001a\u0000\u0001\u0010\u0001\u0003\u0001\u0017\u0001\u0016\u0001\u0000\u0001\u0002\u0006\u0004\u0014\u0000\u0001\u0002\u0001\u0016\u0001\u0002\u0001\u0015\u0001\u0002\u0005\u0000\u0001\u000f\u1fa2\u0000\u0001\u000f\u0001\u000f\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000";
    private static final char[] ZZ_CMAP = CSSellyLexer.zzUnpackCMap("\t\u0002\u0001\b\u0001\u0007\u0001\u000e\u0001\t\u0001\u0006\u0012\u0002\u0001\b\u0001\u0002\u0001\u000b\u0001\u0011\u0001\u0016\u0002\u0002\u0001\f\u0001\u0013\u0001\u001a\u0001\r\u0001\u0019\u0001\u0002\u0001\u0001\u0001\n\u0001\u0002\n\u0005\u0001\u0012\u0002\u0002\u0001\u0014\u0001\u0018\u0002\u0002\u001a\u0000\u0001\u0010\u0001\u0003\u0001\u0017\u0001\u0016\u0001\u0000\u0001\u0002\u0006\u0004\u0014\u0000\u0001\u0002\u0001\u0016\u0001\u0002\u0001\u0015\u0001\u0002\u0005\u0000\u0001\u000f\u1fa2\u0000\u0001\u000f\u0001\u000f\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\uffff\u0000\udfe6\u0000");
    private static final int[] ZZ_ACTION = CSSellyLexer.zzUnpackAction();
    private static final String ZZ_ACTION_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0001\u0002\u0003\u0003\u0001\u0004\u0001\u0005\u0001\u0006\u0002\u0007\u0001\b\u0002\u0007\u0001\t\u0003\u0006\u0001\n\u0001\u000b\u0001\u0001\u0001\f\u0001\r\u0001\u000e\u0004\u0006\u0001\u000f\u0001\u0000\u0001\u0002\u0001\u0010\u0002\u0000\u0001\u0011\u0001\u0000\u0001\u0012\u0004\u0000\u0001\t\u0002\u0000\u0001\t\t\u0000\u0001\u000f\u0001\u0000\u0002\u0002\u0001\u0010\u0001\u0011\u0001\u0013\u0001\u0012\u0001\t\u0004\u0000\u0002\t\u0001\u0000\u0001\u000f\u0005\u0000\u0001\u0002\u0002\u0010\u0002\u0011\u0002\u0012\u0002\t\u0002\u0000\u0001\t\u0006\u0000\u0001\u0002\u0001\u0010\u0001\u0011\u0001\u0012\u0002\t\u0002\u0000\u0001\t\u0002\u0000\u0002\t\u0004\u0000\u0001\u0002\u0001\u0010\u0001\u0011\u0001\u0012\u0001\t\u0002\u0000\u0001\t\u0004\u0000\u0001\u0002\u0001\u0010\u0001\u0011\u0001\u0012\u0001\t\u0002\u0000\u0001\t\u0004\u0000\u0001\u0010\u0001\u0011\u0001\u0012\u0001\t\u0006\u0000\u0001\t\u0006\u0000";
    private static final int[] ZZ_ROWMAP = CSSellyLexer.zzUnpackRowMap();
    private static final String ZZ_ROWMAP_PACKED_0 = "\u0000\u0000\u0000\u001b\u00006\u0000Q\u0000l\u0000\u0087\u0000\u00a2\u0000\u00bd\u0000\u00d8\u0000\u00f3\u0000\u00bd\u0000\u00bd\u0000\u00bd\u0000\u010e\u0000\u00bd\u0000\u0129\u0000\u0144\u0000\u015f\u0000\u017a\u0000\u0195\u0000\u01b0\u0000\u00bd\u0000\u00bd\u0000\u01cb\u0000\u01e6\u0000\u0201\u0000\u021c\u0000\u0237\u0000\u0252\u0000\u026d\u0000\u0288\u0000\u0237\u0000\u00d8\u0000\u02a3\u0000\u02be\u0000\u02d9\u0000\u02f4\u0000\u0129\u0000\u030f\u0000\u032a\u0000\u0345\u0000\u0360\u0000\u037b\u0000\u0195\u0000\u0396\u0000\u03b1\u0000\u03cc\u0000\u03e7\u0000\u017a\u0000\u01b0\u0000\u0237\u0000\u0252\u0000\u026d\u0000\u0288\u0000\u0402\u0000\u041d\u0000\u0438\u0000\u026d\u0000\u0453\u0000\u046e\u0000\u0489\u0000\u04a4\u0000\u04bf\u0000\u00bd\u0000\u04da\u0000\u04f5\u0000\u0510\u0000\u052b\u0000\u0546\u0000\u0561\u0000\u057c\u0000\u0597\u0000\u05b2\u0000\u0402\u0000\u05cd\u0000\u05e8\u0000\u0603\u0000\u061e\u0000\u0639\u0000\u0654\u0000\u066f\u0000\u068a\u0000\u06a5\u0000\u06c0\u0000\u06db\u0000\u06f6\u0000\u0711\u0000\u072c\u0000\u0747\u0000\u0762\u0000\u077d\u0000\u0798\u0000\u07b3\u0000\u07ce\u0000\u07e9\u0000\u0804\u0000\u081f\u0000\u083a\u0000\u0855\u0000\u0870\u0000\u088b\u0000\u08a6\u0000\u08c1\u0000\u08dc\u0000\u08f7\u0000\u0912\u0000\u092d\u0000\u0948\u0000\u0963\u0000\u097e\u0000\u0999\u0000\u09b4\u0000\u09cf\u0000\u09ea\u0000\u0a05\u0000\u0a20\u0000\u0a3b\u0000\u0a56\u0000\u0a71\u0000\u0a8c\u0000\u0aa7\u0000\u0ac2\u0000\u0add\u0000\u0af8\u0000\u0b13\u0000\u0b2e\u0000\u0b49\u0000\u0b64\u0000\u0b7f\u0000\u0b9a\u0000\u0bb5\u0000\u0bd0\u0000\u0beb\u0000\u0c06\u0000\u0c21\u0000\u0c3c\u0000\u0c57\u0000\u0c72\u0000\u0c8d\u0000\u0ca8\u0000\u0cc3\u0000\u0cde\u0000\u0cf9\u0000\u0d14\u0000\u0d2f\u0000\u0d4a\u0000\u0d65\u0000\u0d80\u0000\u0d9b\u0000\u0db6\u0000\u0dd1\u0000\u0dec\u0000\u0e07\u0000\u0e22\u0000\u0e3d";
    private static final int[] ZZ_TRANS = CSSellyLexer.zzUnpackTrans();
    private static final String ZZ_TRANS_PACKED_0 = "\u0001\u0006\u0001\u0007\u0001\b\u0001\t\u0001\u0006\u0001\b\u0004\n\u0003\b\u0001\u000b\u0001\f\u0001\u0006\u000b\b\u0006\r\u0002\f\u0001\r\u0001\f\u0001\u000e\u0003\r\u0002\f\u0001\u000f\u0001\u0010\u0001\u0011\b\r\u0001\u0012\u0001\u0013\u0001\f\u0001\u0014\u0001\u0012\u0001\f\u0004\u0015\u0005\f\u0001\u0012\u0007\f\u0001\u0016\u0003\f\u0006\u0017\u0004\u0018\u0004\u0017\u0002\f\u0005\u0017\u0001\u0019\u0002\u0017\u0001\u001a\u0001\u001b\u0001\u0017\u0003\u001c\u0001\u001d\u0007\u001c\u0001\u001e\u0001\u001f\r\u001c\u0001 \u0002\u0006\u0001\u0000\u0001!\u0002\u0006\t\u0000\u0001\u0006\u000b\u0000\u0001\u0006\u0002\u0000\u0001!\u0001\u0006\n\u0000\u0001\u0006&\u0000\u0004\u0006\u0002\"\u0002\u0000\u0001\u0006\u0001\u0000\u0011\u0006\u0006\u0000\u0004\n\u0011\u0000\u0001#\u0001$\u0001\u0000\u0001%\u0001#\n\u0000\u0001#\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002&\t\u0000\u0001&\u000b\u0000\u0001(\u0001)\u0001\u0000\u0001*\u0001(\n\u0000\u0001(\u0002\u0000\u0001+\b\u0000\u0002\u0012\u0001\u0000\u0001,\u0002\u0012\u0004-\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u0001\u0012\u0002\u0000\u0001,\u0001\u0012\n\u0000\u0001\u0012\u000b\u0000\u0004\u0012\u00020\u0002\u0000\u0001\u0012\u0001\u0000\u0012\u0012\u00011\u0001\u0000\u0001,\u0001\u0012\u0001\u0000\u00042\u0005\u0000\u0001\u0012\u0011\u0000\u0004\u0018\u000b\u0000\u0001\u0019\u0002\u0000\u0001\u001a\u0001\u001b\u0007\u0000\u0004\u0019\u0017\u0000\u0004\u001a\u0017\u0000\u0004\u001b\u0011\u0000\u00033\u00014\u00073\u00015\u00016\r3\u0001 \u00033\u00014\u00073\u00015\u00017\r3\u0001 \u00035\u00018\u00025\u00023\u00015\u00013\u00025\u00019\r5\u0001:\u00036\u0001;\u00026\u0002\u0000\u00016\u0001\u0000\u00026\u00013\u000e6\u0002\u0006\u0001\u0000\u0001!\u0002<\u0001=\u0003\u0006\u0005\u0000\u0001\u0006\u000b\u0000\u0002#\u0001\u0000\u0001%\u0002#\t\u0000\u0001#\u000b\u0000\u0001#\u0002\u0000\u0001%\u0001#\n\u0000\u0001#\u000b\u0000\u0004#\u0002>\u0002\u0000\u0001#\u0001\u0000\u0011#\u0004&\u0002?\u0002\u0000\u0001&\u0001\u0000\u0011&\u0002(\u0001\u0000\u0001*\u0002(\t\u0000\u0001(\u0003\u0000\u0001@\u0007\u0000\u0001(\u0002\u0000\u0001*\u0001(\n\u0000\u0001(\u000b\u0000\u0004(\u0002A\u0002\u0000\u0001(\u0001\u0000\u0012(\u0001)\u0001\u0000\u0001*\u0001(\n\u0000\u0001(\u0011\u0000\u0004-\u0003\u0000\u0001.\u0006\u0000\u0001/\u0002.\u0018\u0000\u0001/\u0006\u0000\u0001B\u0001C\u0001\u0000\u0001D\u0001B\u0001\u0000\u0004/\u0001\u0000\u0001E\u0001F\u0002\u0000\u0001B\u000b\u0000\u0002\u0012\u0001\u0000\u0001,\u0002G\u0001H\u0003\u0012\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u00037\u0001I\u00027\u00023\u00017\u00013\u00107\u0001J\u00035\u00018\u0002K\u0001L\u00055\u00017\r5\u0001:\u00039\u0001M\u00029\u0002\u0000\u00019\u0001\u0000\u00019\u00017\u00015\u000e9\u00036\u0001;\u0002N\u0001O\u00056\u00017\u000e6\u0002\u0006\u0001\u0000\u0001!\u0002P\u0001=\u0003\u0006\u0005\u0000\u0001\u0006\u000b\u0000\u0002\u0006\u0001\u0000\u0001!\u0002\u0006\u0001\u0000\u0001\u0006\u0007\u0000\u0001\u0006\u000b\u0000\u0002#\u0001\u0000\u0001%\u0002Q\u0001R\u0003#\u0005\u0000\u0001#\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002S\u0001T\u0003&\u0005\u0000\u0001&\u000b\u0000\u0002(\u0001\u0000\u0001*\u0002U\u0001V\u0003(\u0005\u0000\u0001(\u0003\u0000\u0001@\u0007\u0000\u0002B\u0001\u0000\u0001D\u0002B\u0004W\u0005\u0000\u0001B\u000b\u0000\u0001B\u0002\u0000\u0001D\u0001B\n\u0000\u0001B\u000b\u0000\u0004B\u0002X\u0002\u0000\u0001B\u0001\u0000\u0011B\u0003E\u0001Y\u0002E\u0002\u0000\u0001E\u0001\u0000\u0001E\u0001W\u000fE\u0003F\u0001Z\u0002F\u0002\u0000\u0001F\u0001\u0000\u0002F\u0001W\u000eF\u0002\u0012\u0001\u0000\u0001,\u0002[\u0001H\u0003\u0012\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u0002\u0012\u0001\u0000\u0001,\u0002\u0012\u0001-\u0001\u0012\u0002-\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u00037\u0001I\u0002\\\u0001]\u00137\u0001J\u00035\u00018\u0002^\u0001L\u00055\u00019\r5\u0001:\u00035\u00018\u00025\u00013\u00025\u00013\u00025\u00019\r5\u0001:\u00039\u0001M\u0002_\u0001`\u00049\u00027\u000e9\u00036\u0001;\u0002a\u0001O\u00056\u00013\u00116\u0001;\u00026\u0001\u0000\u00026\u0001\u0000\u00026\u00013\u000e6\u0002\u0006\u0001\u0000\u0001!\u0002b\u0001=\u0003\u0006\u0005\u0000\u0001\u0006\u000b\u0000\u0002#\u0001\u0000\u0001%\u0002c\u0001R\u0003#\u0005\u0000\u0001#\u000b\u0000\u0002#\u0001\u0000\u0001%\u0002#\u0001\u0000\u0001#\u0007\u0000\u0001#\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002d\u0001T\u0003&\u0005\u0000\u0001&\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002&\u0001\u0000\u0001&\u0007\u0000\u0001&\u000b\u0000\u0002(\u0001\u0000\u0001*\u0002e\u0001V\u0003(\u0005\u0000\u0001(\u0003\u0000\u0001@\u0007\u0000\u0002(\u0001\u0000\u0001*\u0002(\u0001\u0000\u0001(\u0007\u0000\u0001(\u0003\u0000\u0001@\r\u0000\u0004W\u0011\u0000\u0002B\u0001\u0000\u0001D\u0002f\u0001g\u0003B\u0005\u0000\u0001B\u000b\u0000\u0003E\u0001Y\u0002h\u0001i\u0004E\u0001j\u000fE\u0003F\u0001Z\u0002k\u0001l\u0005F\u0001m\u000eF\u0002\u0012\u0001\u0000\u0001,\u0002n\u0001H\u0003\u0012\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u00037\u0001I\u0002o\u0001]\u00137\u0001J\u00037\u0001I\u00027\u00013\u00027\u00013\u00107\u0001J\u00035\u00018\u0002p\u0001L\u00055\u00019\r5\u0001:\u00039\u0001M\u0002q\u0001`\u00049\u00017\u00015\u00119\u0001M\u00029\u0001\u0000\u00029\u0001\u0000\u00019\u00017\u00015\u000e9\u00036\u0001;\u0002r\u0001O\u00056\u00013\u000e6\u0002\u0006\u0001\u0000\u0001!\u0002s\u0001=\u0003\u0006\u0005\u0000\u0001\u0006\u000b\u0000\u0002#\u0001\u0000\u0001%\u0002t\u0001R\u0003#\u0005\u0000\u0001#\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002u\u0001T\u0003&\u0005\u0000\u0001&\u000b\u0000\u0002(\u0001\u0000\u0001*\u0002v\u0001V\u0003(\u0005\u0000\u0001(\u0003\u0000\u0001@\u0007\u0000\u0002B\u0001\u0000\u0001D\u0002w\u0001g\u0003B\u0005\u0000\u0001B\u000b\u0000\u0002B\u0001\u0000\u0001D\u0002B\u0001W\u0001B\u0002W\u0005\u0000\u0001B\u000b\u0000\u0003E\u0001Y\u0002x\u0001i\u0004E\u0001W\u0012E\u0001Y\u0002E\u0001\u0000\u0002E\u0001\u0000\u0001E\u0001W\u0012E\u0001Y\u0002E\u0002W\u0001j\u0001W\u0001E\u0001W\u000fE\u0003F\u0001Z\u0002y\u0001l\u0005F\u0001W\u0011F\u0001Z\u0002F\u0001\u0000\u0002F\u0001\u0000\u0002F\u0001W\u0011F\u0001Z\u0002F\u0002W\u0001m\u0001W\u0002F\u0001W\u000eF\u0002\u0012\u0001\u0000\u0001,\u0002z\u0001H\u0003\u0012\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u00037\u0001I\u0002{\u0001]\u00137\u0001J\u00035\u00018\u0002|\u0001L\u00055\u00019\r5\u0001:\u00039\u0001M\u0002}\u0001`\u00049\u00017\u00015\u000e9\u00036\u0001;\u0002~\u0001O\u00056\u00013\u000e6\u0002\u0006\u0001\u0000\u0001!\u0002\u007f\u0001=\u0003\u0006\u0005\u0000\u0001\u0006\u000b\u0000\u0002#\u0001\u0000\u0001%\u0002\u0080\u0001R\u0003#\u0005\u0000\u0001#\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002\u0081\u0001T\u0003&\u0005\u0000\u0001&\u000b\u0000\u0002(\u0001\u0000\u0001*\u0002\u0082\u0001V\u0003(\u0005\u0000\u0001(\u0003\u0000\u0001@\u0007\u0000\u0002B\u0001\u0000\u0001D\u0002\u0083\u0001g\u0003B\u0005\u0000\u0001B\u000b\u0000\u0003E\u0001Y\u0002\u0084\u0001i\u0004E\u0001W\u000fE\u0003F\u0001Z\u0002\u0085\u0001l\u0005F\u0001W\u000eF\u0002\u0012\u0001\u0000\u0001,\u0002\u0086\u0001H\u0003\u0012\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u00037\u0001I\u0002\u0087\u0001]\u00137\u0001J\u00035\u00018\u0002\u0088\u0001L\u00055\u00019\r5\u0001:\u00039\u0001M\u0002\u0089\u0001`\u00049\u00017\u00015\u000e9\u00036\u0001;\u0002\u008a\u0001O\u00056\u00013\u000e6\u0002\u0006\u0001\u0000\u0001!\u0002\u0006\u0001=\u0003\u0006\u0005\u0000\u0001\u0006\u000b\u0000\u0002#\u0001\u0000\u0001%\u0002\u008b\u0001R\u0003#\u0005\u0000\u0001#\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002\u008c\u0001T\u0003&\u0005\u0000\u0001&\u000b\u0000\u0002(\u0001\u0000\u0001*\u0002\u008d\u0001V\u0003(\u0005\u0000\u0001(\u0003\u0000\u0001@\u0007\u0000\u0002B\u0001\u0000\u0001D\u0002\u008e\u0001g\u0003B\u0005\u0000\u0001B\u000b\u0000\u0003E\u0001Y\u0002\u008f\u0001i\u0004E\u0001W\u000fE\u0003F\u0001Z\u0002\u0090\u0001l\u0005F\u0001W\u000eF\u0002\u0012\u0001\u0000\u0001,\u0002\u0012\u0001H\u0003\u0012\u0003\u0000\u0001.\u0001\u0000\u0001\u0012\u0004\u0000\u0001/\u0002.\u0004\u0000\u00037\u0001I\u0002\u0091\u0001]\u00137\u0001J\u00035\u00018\u0002\u0092\u0001L\u00055\u00019\r5\u0001:\u00039\u0001M\u0002\u0093\u0001`\u00049\u00017\u00015\u000e9\u00036\u0001;\u0002\u0094\u0001O\u00056\u00013\u000e6\u0002#\u0001\u0000\u0001%\u0002#\u0001R\u0003#\u0005\u0000\u0001#\u000b\u0000\u0002&\u0001\u0000\u0001'\u0002&\u0001T\u0003&\u0005\u0000\u0001&\u000b\u0000\u0002(\u0001\u0000\u0001*\u0002(\u0001V\u0003(\u0005\u0000\u0001(\u0003\u0000\u0001@\u0007\u0000\u0002B\u0001\u0000\u0001D\u0002\u0095\u0001g\u0003B\u0005\u0000\u0001B\u000b\u0000\u0003E\u0001Y\u0002\u0096\u0001i\u0004E\u0001W\u000fE\u0003F\u0001Z\u0002\u0097\u0001l\u0005F\u0001W\u000eF\u00037\u0001I\u0002\u0098\u0001]\u00137\u0001J\u00035\u00018\u00025\u0001L\u00055\u00019\r5\u0001:\u00039\u0001M\u0002\u0099\u0001`\u00049\u00017\u00015\u000e9\u00036\u0001;\u00026\u0001O\u00056\u00013\u000e6\u0002B\u0001\u0000\u0001D\u0002B\u0001g\u0003B\u0005\u0000\u0001B\u000b\u0000\u0003E\u0001Y\u0002\u009a\u0001i\u0004E\u0001W\u000fE\u0003F\u0001Z\u0002\u009b\u0001l\u0005F\u0001W\u000eF\u00037\u0001I\u00027\u0001]\u00137\u0001J\u00039\u0001M\u00029\u0001`\u00049\u00017\u00015\u000e9\u0003E\u0001Y\u0002E\u0001i\u0004E\u0001W\u000fE\u0003F\u0001Z\u0002F\u0001l\u0005F\u0001W\u000eF";
    private static final int ZZ_UNKNOWN_ERROR = 0;
    private static final int ZZ_NO_MATCH = 1;
    private static final int ZZ_PUSHBACK_2BIG = 2;
    private static final String[] ZZ_ERROR_MSG = new String[]{"Unknown internal scanner error", "Error: could not match input", "Error: pushback value was too large"};
    private static final int[] ZZ_ATTRIBUTE = CSSellyLexer.zzUnpackAttribute();
    private static final String ZZ_ATTRIBUTE_PACKED_0 = "\u0003\u0000\u0001\u0001\u0001\u0000\u0002\u0001\u0001\t\u0002\u0001\u0003\t\u0001\u0001\u0001\t\u0006\u0001\u0002\t\t\u0001\u0001\u0000\u0002\u0001\u0002\u0000\u0001\u0001\u0001\u0000\u0001\u0001\u0004\u0000\u0001\u0001\u0002\u0000\u0001\u0001\t\u0000\u0001\u0001\u0001\u0000\u0004\u0001\u0001\t\u0002\u0001\u0004\u0000\u0002\u0001\u0001\u0000\u0001\u0001\u0005\u0000\t\u0001\u0002\u0000\u0001\u0001\u0006\u0000\u0006\u0001\u0002\u0000\u0001\u0001\u0002\u0000\u0002\u0001\u0004\u0000\u0005\u0001\u0002\u0000\u0001\u0001\u0004\u0000\u0005\u0001\u0002\u0000\u0001\u0001\u0004\u0000\u0004\u0001\u0006\u0000\u0001\u0001\u0006\u0000";
    private char[] zzChars;
    private int zzState;
    private int zzLexicalState = 0;
    private char[] zzBuffer;
    private int zzMarkedPos;
    private int zzCurrentPos;
    private int zzStartRead;
    private int zzEndRead;
    private int yyline;
    private int yychar;
    private int yycolumn;
    private boolean zzAtBOL = true;
    private boolean zzAtEOF;
    private boolean zzEOFDone;
    private int zzFinalHighSurrogate = 0;
    ArrayList<CssSelector> selectors = new ArrayList();
    CssSelector cssSelector;
    String pseudoFnName;

    private static int[] zzUnpackAction() {
        int[] result = new int[155];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackAction(ZZ_ACTION_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAction(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackRowMap() {
        int[] result = new int[155];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackRowMap(ZZ_ROWMAP_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackRowMap(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int high = packed.charAt(i++) << 16;
            result[j++] = high | packed.charAt(i++);
        }
        return j;
    }

    private static int[] zzUnpackTrans() {
        int[] result = new int[3672];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackTrans(ZZ_TRANS_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackTrans(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            int value = packed.charAt(i++);
            do {
                result[j++] = --value;
            } while (--count > 0);
        }
        return j;
    }

    private static int[] zzUnpackAttribute() {
        int[] result = new int[155];
        int offset = 0;
        offset = CSSellyLexer.zzUnpackAttribute(ZZ_ATTRIBUTE_PACKED_0, offset, result);
        return result;
    }

    private static int zzUnpackAttribute(String packed, int offset, int[] result) {
        int i = 0;
        int j = offset;
        int l = packed.length();
        while (i < l) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                result[j++] = value;
            } while (--count > 0);
        }
        return j;
    }

    public int position() {
        return this.yychar;
    }

    public int length() {
        return this.yylength();
    }

    public int line() {
        return -1;
    }

    public int column() {
        return -1;
    }

    public void stateReset() {
        this.yybegin(0);
    }

    public void stateSelector() {
        this.yybegin(2);
    }

    public void stateAttr() {
        this.yybegin(4);
    }

    public void stateCombinator() {
        this.yybegin(6);
    }

    public void statePseudoFn() {
        this.yybegin(8);
    }

    public final CharSequence xxtext() {
        return CharBuffer.wrap(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final String yytext(int startIndex) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - startIndex);
    }

    public final String yytext(int startIndex, int endIndexOffset) {
        return new String(this.zzBuffer, startIndex += this.zzStartRead, this.zzMarkedPos - endIndexOffset - startIndex);
    }

    private static char[] zzUnpackCMap(String packed) {
        char[] map = new char[0x110000];
        int i = 0;
        int j = 0;
        while (i < 128) {
            int count = packed.charAt(i++);
            char value = packed.charAt(i++);
            do {
                map[j++] = value;
            } while (--count > 0);
        }
        return map;
    }

    CSSellyLexer(char[] input) {
        this.zzChars = input;
    }

    private boolean zzRefill() {
        if (this.zzBuffer == null) {
            this.zzBuffer = this.zzChars;
            this.zzEndRead += this.zzChars.length;
            return false;
        }
        return true;
    }

    public final void yyclose() {
        this.zzAtEOF = true;
        this.zzEndRead = this.zzStartRead;
    }

    public final int yystate() {
        return this.zzLexicalState;
    }

    public final void yybegin(int newState) {
        this.zzLexicalState = newState;
    }

    public final String yytext() {
        return new String(this.zzBuffer, this.zzStartRead, this.zzMarkedPos - this.zzStartRead);
    }

    public final char yycharat(int pos) {
        return this.zzBuffer[this.zzStartRead + pos];
    }

    public final int yylength() {
        return this.zzMarkedPos - this.zzStartRead;
    }

    private void zzScanError(int errorCode) {
        String message;
        try {
            message = ZZ_ERROR_MSG[errorCode];
        }
        catch (ArrayIndexOutOfBoundsException e) {
            message = ZZ_ERROR_MSG[0];
        }
        throw new Error(message);
    }

    public void yypushback(int number) {
        if (number > this.yylength()) {
            this.zzScanError(2);
        }
        this.zzMarkedPos -= number;
    }

    private void zzDoEOF() throws IOException {
        if (!this.zzEOFDone) {
            this.zzEOFDone = true;
            this.yyclose();
        }
    }

    public int yylex() throws IOException {
        int zzEndReadL = this.zzEndRead;
        char[] zzBufferL = this.zzBuffer;
        char[] zzCMapL = ZZ_CMAP;
        int[] zzTransL = ZZ_TRANS;
        int[] zzRowMapL = ZZ_ROWMAP;
        int[] zzAttrL = ZZ_ATTRIBUTE;
        block39: while (true) {
            int zzInput;
            int zzMarkedPosL = this.zzMarkedPos;
            this.yychar += zzMarkedPosL - this.zzStartRead;
            int zzAction = -1;
            this.zzCurrentPos = this.zzStartRead = zzMarkedPosL;
            int zzCurrentPosL = this.zzStartRead;
            this.zzState = ZZ_LEXSTATE[this.zzLexicalState];
            int zzAttributes = zzAttrL[this.zzState];
            if ((zzAttributes & 1) == 1) {
                zzAction = this.zzState;
            }
            while (true) {
                if (zzCurrentPosL < zzEndReadL) {
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                } else {
                    if (this.zzAtEOF) {
                        zzInput = -1;
                        break;
                    }
                    this.zzCurrentPos = zzCurrentPosL;
                    this.zzMarkedPos = zzMarkedPosL;
                    boolean eof = this.zzRefill();
                    zzCurrentPosL = this.zzCurrentPos;
                    zzMarkedPosL = this.zzMarkedPos;
                    zzBufferL = this.zzBuffer;
                    zzEndReadL = this.zzEndRead;
                    if (eof) {
                        zzInput = -1;
                        break;
                    }
                    zzInput = Character.codePointAt(zzBufferL, zzCurrentPosL, zzEndReadL);
                    zzCurrentPosL += Character.charCount(zzInput);
                }
                int zzNext = zzTransL[zzRowMapL[this.zzState] + zzCMapL[zzInput]];
                if (zzNext == -1) break;
                this.zzState = zzNext;
                zzAttributes = zzAttrL[this.zzState];
                if ((zzAttributes & 1) != 1) continue;
                zzAction = this.zzState;
                zzMarkedPosL = zzCurrentPosL;
                if ((zzAttributes & 8) == 8) break;
            }
            this.zzMarkedPos = zzMarkedPosL;
            if (zzInput == -1 && this.zzStartRead == this.zzCurrentPos) {
                this.zzAtEOF = true;
                this.zzDoEOF();
                return 0;
            }
            switch (zzAction < 0 ? zzAction : ZZ_ACTION[zzAction]) {
                case 1: {
                    this.cssSelector.setCombinator(Combinator.DESCENDANT);
                    this.stateReset();
                }
                case 20: {
                    continue block39;
                }
                case 2: {
                    this.cssSelector = new CssSelector(this.yytext());
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 21: {
                    continue block39;
                }
                case 3: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.yypushback(1);
                    this.stateSelector();
                }
                case 22: {
                    continue block39;
                }
                case 4: 
                case 23: {
                    continue block39;
                }
                case 5: {
                    this.cssSelector = new CssSelector();
                    this.selectors.add(this.cssSelector);
                    this.stateSelector();
                }
                case 24: {
                    continue block39;
                }
                case 6: {
                    throw new CSSellyException("Illegal character <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 25: {
                    continue block39;
                }
                case 7: {
                    this.yypushback(1);
                    this.stateCombinator();
                }
                case 26: {
                    continue block39;
                }
                case 8: {
                    this.stateAttr();
                }
                case 27: {
                    continue block39;
                }
                case 9: {
                    this.cssSelector.addAttributeSelector(this.yytext());
                }
                case 28: {
                    continue block39;
                }
                case 10: {
                    this.stateSelector();
                }
                case 29: {
                    continue block39;
                }
                case 11: {
                    throw new CSSellyException("Invalid combinator <" + this.yytext() + ">.", this.yystate(), this.line(), this.column());
                }
                case 30: {
                    continue block39;
                }
                case 12: {
                    this.cssSelector.setCombinator(Combinator.GENERAL_SIBLING);
                    this.stateReset();
                }
                case 31: {
                    continue block39;
                }
                case 13: {
                    this.cssSelector.setCombinator(Combinator.CHILD);
                    this.stateReset();
                }
                case 32: {
                    continue block39;
                }
                case 14: {
                    this.cssSelector.setCombinator(Combinator.ADJACENT_SIBLING);
                    this.stateReset();
                }
                case 33: {
                    continue block39;
                }
                case 15: {
                    this.cssSelector.addPseudoFunctionSelector(this.pseudoFnName, this.yytext(0, 1));
                    this.stateSelector();
                }
                case 34: {
                    continue block39;
                }
                case 16: {
                    this.cssSelector.addClassSelector(this.yytext(1));
                }
                case 35: {
                    continue block39;
                }
                case 17: {
                    this.cssSelector.addIdSelector(this.yytext(1));
                }
                case 36: {
                    continue block39;
                }
                case 18: {
                    this.cssSelector.addPseudoClassSelector(this.yytext(this.yycharat(1) == ':' ? 2 : 1));
                }
                case 37: {
                    continue block39;
                }
                case 19: {
                    this.pseudoFnName = this.yytext(this.yycharat(1) == ':' ? 2 : 1, 1);
                    this.statePseudoFn();
                }
                case 38: {
                    continue block39;
                }
            }
            this.zzScanError(1);
        }
    }
}

