/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc;

import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocException;
import jodd.madvoc.WebApplication;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.component.FiltersManager;
import jodd.madvoc.component.InterceptorsManager;
import jodd.madvoc.component.MadvocConfig;
import jodd.madvoc.component.MadvocController;
import jodd.madvoc.component.ResultsManager;
import jodd.madvoc.config.AutomagicMadvocConfigurator;
import jodd.madvoc.config.MadvocConfigurator;
import jodd.props.Props;
import jodd.props.PropsUtil;
import jodd.typeconverter.Convert;
import jodd.util.ClassLoaderUtil;

public class Madvoc {
    public static final String PARAM_MADVOC_WEBAPP = "madvoc.webapp";
    public static final String PARAM_MADVOC_CONFIGURATOR = "madvoc.configurator";
    public static final String PARAM_MADVOC_PARAMS = "madvoc.params";
    private static Logger log;
    public static final String MADVOC_ATTR;
    protected String webAppClassName;
    protected Class webAppClass;
    protected String[] paramsFiles;
    protected String madvocConfiguratorClassName;
    protected Class madvocConfiguratorClass;
    protected WebApplication webapp;
    protected MadvocController madvocController;
    protected MadvocConfig madvocConfig;
    protected ServletContext servletContext;

    public static Madvoc get(ServletContext servletContext) {
        return (Madvoc)servletContext.getAttribute(MADVOC_ATTR);
    }

    public void setWebAppClassName(String webAppClass) {
        this.webAppClassName = webAppClass;
    }

    public void setWebAppClass(Class webAppClass) {
        this.webAppClass = webAppClass;
    }

    public void setMadvocConfiguratorClassName(String madvocConfiguratorClassName) {
        this.madvocConfiguratorClassName = madvocConfiguratorClassName;
    }

    public void setMadvocConfiguratorClass(Class madvocConfiguratorClass) {
        this.madvocConfiguratorClass = madvocConfiguratorClass;
    }

    public void setParamsFiles(String[] paramsFiles) {
        this.paramsFiles = paramsFiles;
    }

    public void configure(FilterConfig filterConfig) {
        this.webAppClassName = filterConfig.getInitParameter(PARAM_MADVOC_WEBAPP);
        this.paramsFiles = Convert.toStringArray(filterConfig.getInitParameter(PARAM_MADVOC_PARAMS));
        this.madvocConfiguratorClassName = filterConfig.getInitParameter(PARAM_MADVOC_CONFIGURATOR);
    }

    public void configure(ServletContext servletContext) {
        this.webAppClassName = servletContext.getInitParameter(PARAM_MADVOC_WEBAPP);
        this.paramsFiles = Convert.toStringArray(servletContext.getInitParameter(PARAM_MADVOC_PARAMS));
        this.madvocConfiguratorClassName = servletContext.getInitParameter(PARAM_MADVOC_CONFIGURATOR);
    }

    public MadvocController getMadvocController() {
        return this.madvocController;
    }

    public MadvocConfig getMadvocConfig() {
        return this.madvocConfig;
    }

    public WebApplication getWebApplication() {
        return this.webapp;
    }

    public void startNewWebApplication(ServletContext servletContext) {
        try {
            this.start(servletContext);
            log.info("Madvoc is up and running.");
        }
        catch (Exception ex) {
            if (log != null) {
                log.error("Madvoc startup failure.", ex);
            } else {
                ex.printStackTrace();
            }
            if (ex instanceof MadvocException) {
                throw (MadvocException)ex;
            }
            throw new MadvocException(ex);
        }
    }

    private void start(ServletContext servletContext) {
        if (servletContext != null) {
            this.servletContext = servletContext;
            servletContext.setAttribute(MADVOC_ATTR, (Object)this);
        }
        this.webapp = this.createWebApplication();
        this.webapp.initWebApplication();
        log = LoggerFactory.getLogger(Madvoc.class);
        log.info("Madvoc starting...");
        if (this.webapp.getClass().equals(WebApplication.class)) {
            log.info("Default Madvoc web application created.");
        } else {
            log.info("Madvoc web application: " + this.webAppClass.getName());
        }
        if (this.paramsFiles != null) {
            Props params = this.loadMadvocParams(this.paramsFiles);
            this.webapp.defineParams(params);
        }
        this.webapp.registerMadvocComponents();
        this.madvocConfig = this.webapp.getComponent(MadvocConfig.class);
        if (this.madvocConfig == null) {
            throw new MadvocException("Madvoc configuration not found");
        }
        this.webapp.init(this.madvocConfig, servletContext);
        FiltersManager filtersManager = this.webapp.getComponent(FiltersManager.class);
        if (filtersManager == null) {
            throw new MadvocException("Madvoc filers manager not found");
        }
        this.webapp.initFilters(filtersManager);
        InterceptorsManager interceptorsManager = this.webapp.getComponent(InterceptorsManager.class);
        if (interceptorsManager == null) {
            throw new MadvocException("Madvoc interceptors manager not found");
        }
        this.webapp.initInterceptors(interceptorsManager);
        ActionsManager actionsManager = this.webapp.getComponent(ActionsManager.class);
        if (actionsManager == null) {
            throw new MadvocException("Madvoc actions manager not found");
        }
        this.webapp.initActions(actionsManager);
        ResultsManager resultsManager = this.webapp.getComponent(ResultsManager.class);
        if (resultsManager == null) {
            throw new MadvocException("Madvoc results manager not found");
        }
        this.webapp.initResults(resultsManager);
        MadvocConfigurator configurator = this.loadMadvocConfig();
        this.webapp.configure(configurator);
        this.madvocController = this.webapp.getComponent(MadvocController.class);
        if (this.madvocController == null) {
            throw new MadvocException("Madvoc controller not found");
        }
        this.madvocController.init(servletContext);
        this.webapp.ready();
    }

    public void stopWebApplication() {
        log.info("Madvoc shutting down...");
        if (this.servletContext != null) {
            this.servletContext.removeAttribute(MADVOC_ATTR);
        }
        this.webapp.destroy(this.madvocConfig);
    }

    protected WebApplication createWebApplication() {
        WebApplication webApp;
        if (this.webAppClassName != null && this.webAppClass != null) {
            throw new MadvocException("Ambiguous WebApplication setting");
        }
        if (this.webAppClassName == null && this.webAppClass == null) {
            return new WebApplication();
        }
        try {
            if (this.webAppClass == null) {
                this.webAppClass = ClassLoaderUtil.loadClass(this.webAppClassName);
            }
            webApp = (WebApplication)this.webAppClass.newInstance();
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to load Madvoc web application class: " + this.webAppClassName, ex);
        }
        return webApp;
    }

    protected Props loadMadvocParams(String[] patterns) {
        if (log.isInfoEnabled()) {
            log.info("Loading Madvoc parameters from: " + Convert.toString(patterns));
        }
        try {
            return PropsUtil.createFromClasspath(patterns);
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to load Madvoc parameters from: " + Convert.toString(patterns) + ".properties': " + ex.toString(), ex);
        }
    }

    protected MadvocConfigurator loadMadvocConfig() {
        MadvocConfigurator configurator;
        if (this.madvocConfiguratorClassName != null && this.madvocConfiguratorClass != null) {
            throw new MadvocException("Ambiguous MadvocConfigurator setting");
        }
        if (this.madvocConfiguratorClassName == null && this.madvocConfiguratorClass == null) {
            log.info("Configuring Madvoc using default automagic configurator");
            return new AutomagicMadvocConfigurator();
        }
        try {
            if (this.madvocConfiguratorClass == null) {
                this.madvocConfiguratorClass = ClassLoaderUtil.loadClass(this.madvocConfiguratorClassName);
            }
            configurator = (MadvocConfigurator)this.madvocConfiguratorClass.newInstance();
            log.info("Configuring Madvoc using configurator: " + this.madvocConfiguratorClass.getName());
        }
        catch (Exception ex) {
            throw new MadvocException("Unable to load Madvoc configurator class: " + this.madvocConfiguratorClassName, ex);
        }
        return configurator;
    }

    static {
        MADVOC_ATTR = Madvoc.class.getName();
    }
}

