/*
 * Decompiled with CFR 0.152.
 */
package jodd.proxetta.asm;

import java.util.ArrayList;
import java.util.List;
import jodd.asm.TraceSignatureVisitor;
import jodd.asm5.signature.SignatureVisitor;
import jodd.mutable.MutableInteger;
import jodd.proxetta.AnnotationInfo;
import jodd.proxetta.ClassInfo;
import jodd.proxetta.MethodInfo;
import jodd.proxetta.ProxettaException;
import jodd.util.collection.IntArrayList;

public class MethodSignatureVisitor
extends TraceSignatureVisitor
implements MethodInfo {
    protected int access;
    protected String methodName;
    protected String signature;
    protected int argumentsCount;
    protected int argumentsWords;
    protected MutableInteger returnOpcodeType;
    protected StringBuilder returnTypeName;
    protected String classname;
    protected String description;
    protected String rawSignature;
    protected AnnotationInfo[] annotations;
    protected boolean visitingArgument;
    protected StringBuilder argumentsOpcodeType;
    protected IntArrayList argumentsOffset;
    protected List<String> argumentsTypeNames;
    protected AnnotationInfo[][] argumentsAnnotation;
    protected String declaredClassName;
    protected ClassInfo targetClassInfo;
    protected boolean isStatic;

    public MethodSignatureVisitor(String methodName, int access, String classname, String description, String signature, ClassInfo targetClassInfo) {
        this();
        this.isInterface = (access & 0x200) != 0;
        this.isStatic = (access & 8) != 0;
        this.methodName = methodName;
        this.access = access;
        this.classname = classname;
        this.description = description;
        this.targetClassInfo = targetClassInfo;
        this.rawSignature = signature;
    }

    private MethodSignatureVisitor() {
        super(new StringBuilder());
    }

    private MethodSignatureVisitor(StringBuilder declaration) {
        super(declaration);
    }

    private MethodSignatureVisitor(StringBuilder buf, MutableInteger returnOpcodeType, StringBuilder returnTypeName) {
        this(buf);
        this.returnOpcodeType = returnOpcodeType;
        this.returnTypeName = returnTypeName;
    }

    @Override
    public SignatureVisitor visitParameterType() {
        super.visitParameterType();
        this.visitingArgument = true;
        if (this.argumentsOpcodeType == null) {
            this.argumentsOpcodeType = new StringBuilder();
            this.argumentsOffset = new IntArrayList();
            this.argumentsTypeNames = new ArrayList<String>();
            this.argumentsOpcodeType.append('L');
            this.argumentsOffset.add(0);
            this.argumentsTypeNames.add(null);
        }
        return this;
    }

    @Override
    public SignatureVisitor visitReturnType() {
        super.visitReturnType();
        this.returnOpcodeType = new MutableInteger();
        this.returnTypeName = new StringBuilder();
        return new MethodSignatureVisitor(this.returnType, this.returnOpcodeType, this.returnTypeName);
    }

    @Override
    public SignatureVisitor visitExceptionType() {
        super.visitExceptionType();
        return new MethodSignatureVisitor(this.exceptions);
    }

    @Override
    public void visitBaseType(char descriptor) {
        String name = null;
        char type = descriptor;
        if (this.isArray()) {
            type = '[';
            name = this.getArrayDepthString() + descriptor;
        }
        super.visitBaseType(descriptor);
        this.maybeUseType(type, name);
    }

    @Override
    public void visitTypeVariable(String name) {
        super.visitTypeVariable(name);
        this.maybeUseType('L', name);
    }

    @Override
    public SignatureVisitor visitArrayType() {
        super.visitArrayType();
        return this;
    }

    @Override
    public void visitClassType(String name) {
        super.visitClassType(name);
        this.maybeUseType('L', 'L' + name + ';');
    }

    @Override
    public String getSignature() {
        if (this.signature == null) {
            this.signature = this.createSignature();
        }
        return this.signature;
    }

    private String createSignature() {
        StringBuilder methodDeclaration = new StringBuilder(30);
        methodDeclaration.append(this.getReturnType()).append(' ').append(this.methodName).append(this.getDeclaration());
        String genericExceptions = this.getExceptions();
        if (genericExceptions != null) {
            methodDeclaration.append(" throws ").append(genericExceptions);
        }
        return methodDeclaration.toString();
    }

    @Override
    public String getRawSignature() {
        return this.rawSignature;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public int getArgumentsCount() {
        return this.argumentsCount;
    }

    @Override
    public char getArgumentOpcodeType(int index) {
        return this.argumentsOpcodeType.charAt(index);
    }

    @Override
    public String getArgumentTypeName(int i) {
        return this.argumentsTypeNames.get(i);
    }

    @Override
    public int getArgumentOffset(int index) {
        return this.argumentsOffset.get(index);
    }

    @Override
    public AnnotationInfo[] getArgumentAnnotations(int index) {
        return this.argumentsAnnotation[index];
    }

    @Override
    public int getAllArgumentsSize() {
        return this.argumentsWords;
    }

    @Override
    public char getReturnOpcodeType() {
        return (char)this.returnOpcodeType.value;
    }

    @Override
    public String getReturnTypeName() {
        return this.returnTypeName.toString();
    }

    @Override
    public int getAccessFlags() {
        return this.access;
    }

    @Override
    public String getClassname() {
        return this.classname;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public AnnotationInfo[] getAnnotations() {
        return this.annotations;
    }

    @Override
    public String getDeclaredClassName() {
        if (this.declaredClassName == null) {
            return this.classname;
        }
        return this.declaredClassName;
    }

    public void setDeclaredClassName(String declaredClassName) {
        this.declaredClassName = declaredClassName;
    }

    @Override
    public boolean isTopLevelMethod() {
        return this.declaredClassName == null;
    }

    @Override
    public ClassInfo getClassInfo() {
        return this.targetClassInfo;
    }

    private boolean isArray() {
        return this.arrayStack != 0;
    }

    private String getArrayDepthString() {
        int aStack = this.arrayStack;
        StringBuilder ads = new StringBuilder();
        while (aStack % 2 != 0) {
            aStack /= 2;
            ads.append('[');
        }
        return ads.toString();
    }

    private void maybeUseType(char type, String typeName) {
        if (this.visitingArgument) {
            if (this.isArray()) {
                type = (char)91;
                typeName = this.getArrayDepthString() + typeName;
            }
            if (type == 'V') {
                throw new ProxettaException("Method argument can't be void");
            }
            ++this.argumentsCount;
            this.argumentsOpcodeType.append(type);
            this.argumentsOffset.add(this.argumentsWords + 1);
            this.argumentsTypeNames.add(typeName);
            this.argumentsWords = type == 'D' || type == 'J' ? (this.argumentsWords += 2) : ++this.argumentsWords;
            this.visitingArgument = false;
        } else if (this.returnOpcodeType != null) {
            if (this.isArray()) {
                type = (char)91;
                typeName = this.getArrayDepthString() + typeName;
            }
            this.returnOpcodeType.value = type;
            if (this.returnTypeName.length() == 0 && typeName != null) {
                this.returnTypeName.append(typeName);
            }
        }
    }

    public String toString() {
        return this.getDeclaredClassName() + '#' + this.getMethodName() + this.getDescription();
    }
}

