/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.lang.reflect.Field;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import sun.misc.Unsafe;

final class PlatformInternal {
    private static final Unsafe UNSAFE;
    private static final long STRING_VALUE_FIELD_OFFSET;
    private static final long STRING_OFFSET_FIELD_OFFSET;
    private static final long STRING_COUNT_FIELD_OFFSET;

    private PlatformInternal() {
    }

    static boolean hasUnsafe() {
        return UNSAFE != null;
    }

    static char[] unsafeGetChars(String string) {
        char[] value = (char[])UNSAFE.getObject(string, STRING_VALUE_FIELD_OFFSET);
        if (STRING_OFFSET_FIELD_OFFSET != -1L) {
            int offset = UNSAFE.getInt(string, STRING_OFFSET_FIELD_OFFSET);
            int count = UNSAFE.getInt(string, STRING_COUNT_FIELD_OFFSET);
            if (offset == 0 && count == value.length) {
                return value;
            }
            char[] result = new char[count];
            System.arraycopy(value, offset, result, 0, count);
            return result;
        }
        return value;
    }

    static String unsafeCreateString(char[] chars) {
        String mutable = new String();
        UNSAFE.putObject(mutable, STRING_VALUE_FIELD_OFFSET, chars);
        if (STRING_COUNT_FIELD_OFFSET != -1L) {
            UNSAFE.putInt(mutable, STRING_COUNT_FIELD_OFFSET, chars.length);
        }
        return mutable;
    }

    static {
        Unsafe unsafe;
        Field addressField;
        ByteBuffer direct = ByteBuffer.allocateDirect(1);
        try {
            addressField = Buffer.class.getDeclaredField("address");
            addressField.setAccessible(true);
            if (addressField.getLong(ByteBuffer.allocate(1)) != 0L) {
                addressField = null;
            } else if (addressField.getLong(direct) == 0L) {
                addressField = null;
            }
        }
        catch (Throwable t) {
            addressField = null;
        }
        if (addressField != null) {
            try {
                Field unsafeField = Unsafe.class.getDeclaredField("theUnsafe");
                unsafeField.setAccessible(true);
                unsafe = (Unsafe)unsafeField.get(null);
            }
            catch (Throwable cause) {
                unsafe = null;
            }
        } else {
            unsafe = null;
        }
        UNSAFE = unsafe;
        long stringValueFieldOffset = -1L;
        long stringOffsetFieldOffset = -1L;
        long stringCountFieldOffset = -1L;
        if (UNSAFE != null) {
            try {
                stringValueFieldOffset = UNSAFE.objectFieldOffset(String.class.getDeclaredField("value"));
                stringOffsetFieldOffset = UNSAFE.objectFieldOffset(String.class.getDeclaredField("offset"));
                stringCountFieldOffset = UNSAFE.objectFieldOffset(String.class.getDeclaredField("count"));
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        STRING_VALUE_FIELD_OFFSET = stringValueFieldOffset;
        STRING_OFFSET_FIELD_OFFSET = stringOffsetFieldOffset;
        STRING_COUNT_FIELD_OFFSET = stringCountFieldOffset;
    }
}

