/*
 * Decompiled with CFR 0.152.
 */
package jodd.core;

import java.lang.module.ModuleDescriptor;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class JavaBridge {
    private static String RESOURCE = JavaBridge.class.getName().replace('.', '/') + ".class";
    private static final String MANIFEST = "META-INF/MANIFEST.MF";

    public static URL[] getURLs(ClassLoader classLoader) {
        if (classLoader instanceof URLClassLoader) {
            URLClassLoader urlClassLoader = (URLClassLoader)classLoader;
            return urlClassLoader.getURLs();
        }
        ArrayList<URL> urls = new ArrayList<URL>();
        urls.add(JavaBridge.currentModuleURL());
        ModuleDescriptor moduleDescriptor = JavaBridge.class.getModule().getDescriptor();
        if (moduleDescriptor != null) {
            moduleDescriptor.requires().forEach(req -> ModuleLayer.boot().findModule(req.name()).ifPresent(mod -> {
                URL url;
                ClassLoader moduleClassLoader = mod.getClassLoader();
                if (moduleClassLoader != null && (url = moduleClassLoader.getResource(MANIFEST)) != null) {
                    url = JavaBridge.fixManifestUrl((URL)url);
                    urls.add(url);
                }
            }));
        }
        return urls.toArray(new URL[urls.size()]);
    }

    private static URL fixManifestUrl(URL url) {
        Object urlString = url.toString();
        int ndx = ((String)urlString).indexOf(MANIFEST);
        urlString = ((String)urlString).substring(0, ndx) + ((String)urlString).substring(ndx + MANIFEST.length());
        try {
            return new URL((String)urlString);
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }

    private static URL currentModuleURL() {
        URL url = JavaBridge.class.getClassLoader().getResource(RESOURCE);
        if (url == null) {
            return null;
        }
        Object urlString = url.toString();
        int ndx = ((String)urlString).indexOf(RESOURCE);
        urlString = ((String)urlString).substring(0, ndx) + ((String)urlString).substring(ndx + RESOURCE.length());
        try {
            return new URL((String)urlString);
        }
        catch (MalformedURLException ignore) {
            return null;
        }
    }
}

