/*
 * Decompiled with CFR 0.152.
 */
package jodd.csselly.selector;

import java.util.List;
import jodd.lagarto.dom.Node;

public abstract class PseudoClass {
    public abstract boolean match(Node var1);

    public boolean match(List<Node> currentResults, Node node, int index) {
        return true;
    }

    public String getPseudoClassName() {
        String name = this.getClass().getSimpleName().toLowerCase();
        name = name.replace('_', '-');
        return name;
    }

    public static class ODD
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return true;
        }

        @Override
        public boolean match(List<Node> currentResults, Node node, int index) {
            return index % 2 != 0;
        }
    }

    public static class EVEN
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return true;
        }

        @Override
        public boolean match(List<Node> currentResults, Node node, int index) {
            return index % 2 == 0;
        }
    }

    public static class TEXT
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("text");
        }
    }

    public static class SUBMIT
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("submit");
        }
    }

    public static class CHECKED
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.hasAttribute("checked");
        }
    }

    public static class SELECTED
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.hasAttribute("selected");
        }
    }

    public static class RESET
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("reset");
        }
    }

    public static class RADIO
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("radio");
        }
    }

    public static class PASSWORD
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("password");
        }
    }

    public static class PARENT
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getChildNodesCount() != 0;
        }
    }

    public static class INPUT
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String tagName = node.getNodeName();
            if (tagName == null) {
                return false;
            }
            if (tagName.equals("button")) {
                return true;
            }
            if (tagName.equals("input")) {
                return true;
            }
            if (tagName.equals("select")) {
                return true;
            }
            return tagName.equals("textarea");
        }
    }

    public static class IMAGE
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("image");
        }
    }

    public static class HEADER
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String name = node.getNodeName();
            if (name == null) {
                return false;
            }
            if (name.length() != 2) {
                return false;
            }
            char c1 = name.charAt(0);
            if (c1 != 'h' && c1 != 'H') {
                return false;
            }
            int c2 = name.charAt(1) - 48;
            return c2 >= 1 && c2 <= 6;
        }
    }

    public static class FILE
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("file");
        }
    }

    public static class CHECKBOX
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("checkbox");
        }
    }

    public static class BUTTON
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            String type = node.getAttribute("type");
            if (type == null) {
                return false;
            }
            return type.equals("button");
        }
    }

    public static class LAST
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return true;
        }

        @Override
        public boolean match(List<Node> currentResults, Node node, int index) {
            int size = currentResults.size();
            if (size == 0) {
                return false;
            }
            Node lastNode = currentResults.get(size - 1);
            if (lastNode == null) {
                return false;
            }
            return lastNode == node;
        }
    }

    public static class FIRST
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return true;
        }

        @Override
        public boolean match(List<Node> currentResults, Node node, int index) {
            if (currentResults.isEmpty()) {
                return false;
            }
            Node firstNode = currentResults.get(0);
            if (firstNode == null) {
                return false;
            }
            return firstNode == node;
        }
    }

    public static class ONLY_OF_TYPE
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getSiblingNameIndex() == 0 && node.getNextSiblingName() == null;
        }
    }

    public static class EMPTY
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getChildNodesCount() == 0;
        }
    }

    public static class ROOT
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getParentNode().getNodeType() == Node.NodeType.DOCUMENT;
        }
    }

    public static class LAST_OF_TYPE
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getNextSiblingName() == null;
        }
    }

    public static class FIRST_OF_TYPE
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getSiblingNameIndex() == 0;
        }
    }

    public static class ONLY_CHILD
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getSiblingElementIndex() == 0 && node.getParentNode().getChildElementsCount() == 1;
        }
    }

    public static class LAST_CHILD
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getSiblingElementIndex() == node.getParentNode().getChildElementsCount() - 1;
        }
    }

    public static class FIRST_CHILD
    extends PseudoClass {
        @Override
        public boolean match(Node node) {
            return node.getSiblingElementIndex() == 0;
        }
    }
}

