/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom;

import java.io.File;
import java.util.function.Consumer;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.DbOomException;
import jodd.db.oom.meta.DbTable;
import jodd.io.findfile.ClassScanner;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.util.ClassLoaderUtil;

public class AutomagicDbOomConfigurator {
    private static final Logger log = LoggerFactory.getLogger(AutomagicDbOomConfigurator.class);
    private final ClassScanner classScanner = new ClassScanner();
    protected final byte[] dbTableAnnotationBytes;
    protected final boolean registerAsEntities;
    protected DbEntityManager dbEntityManager;
    protected long elapsed;
    private Consumer<ClassScanner.EntryData> ENTRY_CONSUMER = new Consumer<ClassScanner.EntryData>(){

        @Override
        public void accept(ClassScanner.EntryData entryData) {
            Class beanClass;
            String entryName = entryData.name();
            if (!entryData.isTypeSignatureInUse(AutomagicDbOomConfigurator.this.dbTableAnnotationBytes)) {
                return;
            }
            try {
                beanClass = AutomagicDbOomConfigurator.this.classScanner.loadClass(entryName);
            }
            catch (ClassNotFoundException cnfex) {
                throw new DbOomException("Entry class not found: " + entryName, cnfex);
            }
            if (beanClass == null) {
                return;
            }
            DbTable dbTable = beanClass.getAnnotation(DbTable.class);
            if (dbTable == null) {
                return;
            }
            if (AutomagicDbOomConfigurator.this.registerAsEntities) {
                AutomagicDbOomConfigurator.this.dbEntityManager.registerEntity(beanClass);
            } else {
                AutomagicDbOomConfigurator.this.dbEntityManager.registerType(beanClass);
            }
        }
    };

    public AutomagicDbOomConfigurator(boolean registerAsEntities) {
        this.dbTableAnnotationBytes = ClassScanner.bytecodeSignatureOfType(DbTable.class);
        this.registerAsEntities = registerAsEntities;
    }

    public AutomagicDbOomConfigurator() {
        this(true);
    }

    public long getElapsed() {
        return this.elapsed;
    }

    public AutomagicDbOomConfigurator withScanner(Consumer<ClassScanner> scannerConsumer) {
        scannerConsumer.accept(this.classScanner);
        return this;
    }

    public void configure(DbEntityManager dbEntityManager, File[] classpath) {
        this.dbEntityManager = dbEntityManager;
        this.classScanner.smartModeEntries();
        this.classScanner.onEntry(this.ENTRY_CONSUMER);
        this.elapsed = System.currentTimeMillis();
        try {
            this.classScanner.scan(classpath);
        }
        catch (Exception ex) {
            throw new DbOomException("Scan classpath error", ex);
        }
        this.elapsed = System.currentTimeMillis() - this.elapsed;
        if (log.isInfoEnabled()) {
            log.info("DbEntityManager configured in " + this.elapsed + "ms. Total entities: " + dbEntityManager.getTotalNames());
        }
    }

    public void configure(DbEntityManager dbEntityManager) {
        this.configure(dbEntityManager, ClassLoaderUtil.getDefaultClasspath());
    }
}

