/*
 * Decompiled with CFR 0.152.
 */
package jodd.io;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import javax.activation.DataSource;
import jodd.core.JoddCore;
import jodd.core.JoddCoreDefaults;
import jodd.io.FastByteArrayOutputStream;
import jodd.io.FastCharArrayWriter;

public class StreamUtil {
    private static final int ZERO = 0;
    private static final int NEGATIVE_ONE = -1;
    private static final int ALL = -1;
    private static final JoddCoreDefaults JODD_CORE_DEFAULTS = JoddCore.get().defaults();

    public static void close(Closeable closeable) {
        if (closeable != null) {
            if (closeable instanceof Flushable) {
                try {
                    ((Flushable)((Object)closeable)).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            try {
                closeable.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static int copy(Reader input, Writer output) throws IOException {
        int read;
        int numToRead = StreamUtil.bufferSize();
        char[] buffer = new char[numToRead];
        int totalRead = 0;
        while ((read = input.read(buffer, 0, numToRead)) >= 0) {
            output.write(buffer, 0, read);
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static int copy(InputStream input, OutputStream output) throws IOException {
        int read;
        int numToRead = StreamUtil.bufferSize();
        byte[] buffer = new byte[numToRead];
        int totalRead = 0;
        while ((read = input.read(buffer, 0, numToRead)) >= 0) {
            output.write(buffer, 0, read);
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static int copy(Reader input, Writer output, int count) throws IOException {
        int read;
        if (count == -1) {
            return StreamUtil.copy(input, output);
        }
        int numToRead = StreamUtil.bufferSize(count);
        char[] buffer = new char[numToRead];
        int totalRead = 0;
        while (numToRead > 0 && (read = input.read(buffer, 0, StreamUtil.bufferSize(numToRead))) != -1) {
            output.write(buffer, 0, read);
            numToRead -= read;
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static int copy(InputStream input, OutputStream output, int count) throws IOException {
        int read;
        if (count == -1) {
            return StreamUtil.copy(input, output);
        }
        int numToRead = StreamUtil.bufferSize(count);
        byte[] buffer = new byte[numToRead];
        int totalRead = 0;
        while (numToRead > 0 && (read = input.read(buffer, 0, StreamUtil.bufferSize(numToRead))) != -1) {
            output.write(buffer, 0, read);
            numToRead -= read;
            totalRead += read;
        }
        output.flush();
        return totalRead;
    }

    public static byte[] readAvailableBytes(InputStream input) throws IOException {
        int totalRead;
        int read;
        int numToRead = input.available();
        byte[] buffer = new byte[numToRead];
        for (totalRead = 0; totalRead < numToRead && (read = input.read(buffer, totalRead, numToRead - totalRead)) >= 0; totalRead += read) {
        }
        if (totalRead < numToRead) {
            throw new IOException("Failed to completely read InputStream");
        }
        return buffer;
    }

    public static <T extends OutputStream> T copy(Reader input, T output) throws IOException {
        return StreamUtil.copy(input, output, StreamUtil.encoding());
    }

    public static <T extends OutputStream> T copy(Reader input, T output, int count) throws IOException {
        return StreamUtil.copy(input, output, StreamUtil.encoding(), count);
    }

    public static <T extends OutputStream> T copy(Reader input, T output, String encoding) throws IOException {
        return StreamUtil.copy(input, output, encoding, -1);
    }

    public static <T extends OutputStream> T copy(Reader input, T output, String encoding, int count) throws IOException {
        try (OutputStreamWriter out = StreamUtil.outputStreamWriterOf(output, encoding);){
            StreamUtil.copy(input, out, count);
            T t = output;
            return t;
        }
    }

    public static FastByteArrayOutputStream copyToOutputStream(DataSource input) throws IOException {
        return StreamUtil.copyToOutputStream(input.getInputStream());
    }

    public static FastByteArrayOutputStream copyToOutputStream(InputStream input) throws IOException {
        return StreamUtil.copyToOutputStream(input, -1);
    }

    public static FastByteArrayOutputStream copyToOutputStream(InputStream input, int count) throws IOException {
        try (FastByteArrayOutputStream output = StreamUtil.createFastByteArrayOutputStream();){
            StreamUtil.copy(input, output, count);
            FastByteArrayOutputStream fastByteArrayOutputStream = output;
            return fastByteArrayOutputStream;
        }
    }

    public static FastByteArrayOutputStream copyToOutputStream(Reader input) throws IOException {
        return StreamUtil.copyToOutputStream(input, StreamUtil.encoding());
    }

    public static FastByteArrayOutputStream copyToOutputStream(Reader input, String encoding) throws IOException {
        return StreamUtil.copyToOutputStream(input, encoding, -1);
    }

    public static FastByteArrayOutputStream copyToOutputStream(Reader input, int count) throws IOException {
        return StreamUtil.copyToOutputStream(input, StreamUtil.encoding(), count);
    }

    public static FastByteArrayOutputStream copyToOutputStream(Reader input, String encoding, int count) throws IOException {
        try (FastByteArrayOutputStream output = StreamUtil.createFastByteArrayOutputStream();){
            StreamUtil.copy(input, output, encoding, count);
            FastByteArrayOutputStream fastByteArrayOutputStream = output;
            return fastByteArrayOutputStream;
        }
    }

    public static <T extends Writer> T copy(InputStream input, T output) throws IOException {
        return StreamUtil.copy(input, output, StreamUtil.encoding());
    }

    public static <T extends Writer> T copy(InputStream input, T output, int count) throws IOException {
        return StreamUtil.copy(input, output, StreamUtil.encoding(), count);
    }

    public static <T extends Writer> T copy(InputStream input, T output, String encoding) throws IOException {
        return StreamUtil.copy(input, output, encoding, -1);
    }

    public static <T extends Writer> T copy(InputStream input, T output, String encoding, int count) throws IOException {
        StreamUtil.copy((Reader)StreamUtil.inputStreamReadeOf(input, encoding), output, count);
        return output;
    }

    public static FastCharArrayWriter copy(InputStream input) throws IOException {
        return StreamUtil.copy(input, StreamUtil.encoding());
    }

    public static FastCharArrayWriter copy(InputStream input, int count) throws IOException {
        return StreamUtil.copy(input, StreamUtil.encoding(), count);
    }

    public static FastCharArrayWriter copy(InputStream input, String encoding) throws IOException {
        return StreamUtil.copy(input, encoding, -1);
    }

    public static FastCharArrayWriter copy(InputStream input, String encoding, int count) throws IOException {
        try (FastCharArrayWriter output = StreamUtil.createFastCharArrayWriter();){
            StreamUtil.copy(input, output, encoding, count);
            FastCharArrayWriter fastCharArrayWriter = output;
            return fastCharArrayWriter;
        }
    }

    public static FastCharArrayWriter copy(Reader input) throws IOException {
        return StreamUtil.copy(input, -1);
    }

    public static FastCharArrayWriter copy(Reader input, int count) throws IOException {
        try (FastCharArrayWriter output = StreamUtil.createFastCharArrayWriter();){
            StreamUtil.copy(input, output, count);
            FastCharArrayWriter fastCharArrayWriter = output;
            return fastCharArrayWriter;
        }
    }

    public static FastCharArrayWriter copy(DataSource input) throws IOException {
        return StreamUtil.copy(input.getInputStream());
    }

    public static byte[] readBytes(InputStream input) throws IOException {
        return StreamUtil.readBytes(input, -1);
    }

    public static byte[] readBytes(InputStream input, int count) throws IOException {
        return StreamUtil.copyToOutputStream(input, count).toByteArray();
    }

    public static byte[] readBytes(Reader input) throws IOException {
        return StreamUtil.readBytes(input, StreamUtil.encoding());
    }

    public static byte[] readBytes(Reader input, int count) throws IOException {
        return StreamUtil.readBytes(input, StreamUtil.encoding(), count);
    }

    public static byte[] readBytes(Reader input, String encoding) throws IOException {
        return StreamUtil.readBytes(input, encoding, -1);
    }

    public static byte[] readBytes(Reader input, String encoding, int count) throws IOException {
        return StreamUtil.copyToOutputStream(input, encoding, count).toByteArray();
    }

    public static char[] readChars(Reader input) throws IOException {
        return StreamUtil.readChars(input, -1);
    }

    public static char[] readChars(Reader input, int count) throws IOException {
        return StreamUtil.copy(input, count).toCharArray();
    }

    public static char[] readChars(InputStream input) throws IOException {
        return StreamUtil.readChars(input, -1);
    }

    public static char[] readChars(InputStream input, String encoding) throws IOException {
        return StreamUtil.readChars(input, encoding, -1);
    }

    public static char[] readChars(InputStream input, int count) throws IOException {
        return StreamUtil.readChars(input, StreamUtil.encoding(), count);
    }

    public static char[] readChars(InputStream input, String encoding, int count) throws IOException {
        return StreamUtil.copy(input, encoding, count).toCharArray();
    }

    public static boolean compare(InputStream input1, InputStream input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedInputStream)) {
            input1 = new BufferedInputStream(input1);
        }
        if (!(input2 instanceof BufferedInputStream)) {
            input2 = new BufferedInputStream(input2);
        }
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    public static boolean compare(Reader input1, Reader input2) throws IOException {
        int ch2;
        if (!(input1 instanceof BufferedReader)) {
            input1 = new BufferedReader(input1);
        }
        if (!(input2 instanceof BufferedReader)) {
            input2 = new BufferedReader(input2);
        }
        int ch = input1.read();
        while (ch != -1) {
            ch2 = input2.read();
            if (ch != ch2) {
                return false;
            }
            ch = input1.read();
        }
        ch2 = input2.read();
        return ch2 == -1;
    }

    private static int bufferSize() {
        return JODD_CORE_DEFAULTS.getIoBufferSize();
    }

    private static int bufferSize(int count) {
        int ioBufferSize = JODD_CORE_DEFAULTS.getIoBufferSize();
        if (count < ioBufferSize) {
            return count;
        }
        return ioBufferSize;
    }

    private static String encoding() {
        return JODD_CORE_DEFAULTS.getEncoding();
    }

    private static FastCharArrayWriter createFastCharArrayWriter() {
        return new FastCharArrayWriter(StreamUtil.bufferSize());
    }

    private static FastByteArrayOutputStream createFastByteArrayOutputStream() {
        return new FastByteArrayOutputStream(StreamUtil.bufferSize());
    }

    public static InputStreamReader inputStreamReadeOf(InputStream input) throws UnsupportedEncodingException {
        return StreamUtil.inputStreamReadeOf(input, StreamUtil.encoding());
    }

    public static InputStreamReader inputStreamReadeOf(InputStream input, String encoding) throws UnsupportedEncodingException {
        return new InputStreamReader(input, encoding);
    }

    public static OutputStreamWriter outputStreamWriterOf(OutputStream output) throws UnsupportedEncodingException {
        return StreamUtil.outputStreamWriterOf(output, StreamUtil.encoding());
    }

    public static OutputStreamWriter outputStreamWriterOf(OutputStream output, String encoding) throws UnsupportedEncodingException {
        return new OutputStreamWriter(output, encoding);
    }
}

