/*
 * Decompiled with CFR 0.152.
 */
package jodd.io.findfile;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.function.Consumer;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import jodd.io.FileNameUtil;
import jodd.io.FileUtil;
import jodd.io.StreamUtil;
import jodd.io.ZipUtil;
import jodd.io.findfile.FindFile;
import jodd.io.findfile.FindFileException;
import jodd.util.ArraysUtil;
import jodd.util.ClassLoaderUtil;
import jodd.util.Consumers;
import jodd.util.StringUtil;
import jodd.util.inex.InExRuleMatcher;
import jodd.util.inex.InExRules;

public class ClassScanner {
    private static final String CLASS_FILE_EXT = ".class";
    private static final String JAR_FILE_EXT = ".jar";
    protected static String[] systemJars = new String[]{"**/jre/lib/*.jar", "**/jre/lib/ext/*.jar", "**/Java/Extensions/*.jar", "**/Classes/*.jar"};
    protected final InExRules<String, String, String> rulesJars = this.createJarRules();
    protected final InExRules<String, String, String> rulesEntries = this.createEntriesRules();
    protected boolean includeResources;
    protected boolean ignoreException;
    private Consumers<EntryData> entryDataConsumers = Consumers.empty();

    public static ClassScanner get() {
        return new ClassScanner();
    }

    protected InExRules<String, String, String> createJarRules() {
        InExRules<String, String, String> rulesJars = new InExRules<String, String, String>(InExRuleMatcher.WILDCARD_PATH_RULE_MATCHER);
        for (String systemJar : systemJars) {
            rulesJars.exclude(systemJar);
        }
        return rulesJars;
    }

    public ClassScanner excludeJars(String ... excludedJars) {
        for (String excludedJar : excludedJars) {
            this.rulesJars.exclude(excludedJar);
        }
        return this;
    }

    public ClassScanner includeJars(String ... includedJars) {
        for (String includedJar : includedJars) {
            this.rulesJars.include(includedJar);
        }
        return this;
    }

    public ClassScanner includeAllJars(boolean blacklist) {
        if (blacklist) {
            this.rulesJars.blacklist();
        } else {
            this.rulesJars.whitelist();
        }
        return this;
    }

    public ClassScanner excludeAllJars(boolean whitelist) {
        if (whitelist) {
            this.rulesJars.whitelist();
        } else {
            this.rulesJars.blacklist();
        }
        return this;
    }

    protected InExRules<String, String, String> createEntriesRules() {
        return new InExRules<String, String, String>(InExRuleMatcher.WILDCARD_RULE_MATCHER);
    }

    public ClassScanner includeEntries(String ... includedEntries) {
        for (String includedEntry : includedEntries) {
            this.rulesEntries.include(includedEntry);
        }
        return this;
    }

    public ClassScanner includeAllEntries(boolean blacklist) {
        if (blacklist) {
            this.rulesEntries.blacklist();
        } else {
            this.rulesEntries.whitelist();
        }
        return this;
    }

    public ClassScanner excludeAllEntries(boolean whitelist) {
        if (whitelist) {
            this.rulesEntries.whitelist();
        } else {
            this.rulesEntries.blacklist();
        }
        return this;
    }

    public ClassScanner excludeEntries(String ... excludedEntries) {
        for (String excludedEntry : excludedEntries) {
            this.rulesEntries.exclude(excludedEntry);
        }
        return this;
    }

    public ClassScanner smartModeEntries() {
        this.rulesEntries.smartMode();
        return this;
    }

    public ClassScanner includeResources(boolean includeResources) {
        this.includeResources = includeResources;
        return this;
    }

    public ClassScanner ignoreException(boolean ignoreException) {
        this.ignoreException = ignoreException;
        return this;
    }

    protected boolean acceptJar(File jarFile) {
        String path = jarFile.getAbsolutePath();
        path = FileNameUtil.separatorsToUnix(path);
        return this.rulesJars.match(path);
    }

    protected void scanUrl(URL url) {
        File file = FileUtil.toFile(url);
        if (file == null && !this.ignoreException) {
            throw new FindFileException("URL is not a valid file: " + url);
        }
        this.scanPath(file);
    }

    protected void scanPath(File file) {
        String path = file.getAbsolutePath();
        if (StringUtil.endsWithIgnoreCase(path, JAR_FILE_EXT)) {
            if (!this.acceptJar(file)) {
                return;
            }
            this.scanJarFile(file);
        } else if (file.isDirectory()) {
            this.scanClassPath(file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanJarFile(File file) {
        ZipFile zipFile;
        try {
            zipFile = new ZipFile(file);
        }
        catch (IOException ioex) {
            if (!this.ignoreException) {
                throw new FindFileException("Invalid zip: " + file.getName(), ioex);
            }
            return;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        while (entries.hasMoreElements()) {
            ZipEntry zipEntry = entries.nextElement();
            String zipEntryName = zipEntry.getName();
            try {
                EntryData entryData;
                String entryName;
                if (StringUtil.endsWithIgnoreCase(zipEntryName, CLASS_FILE_EXT)) {
                    entryName = this.prepareEntryName(zipEntryName, true);
                    entryData = new EntryData(entryName, zipFile, zipEntry);
                    try {
                        this.scanEntry(entryData);
                        continue;
                    }
                    finally {
                        entryData.closeInputStream();
                        continue;
                    }
                }
                if (!this.includeResources) continue;
                entryName = this.prepareEntryName(zipEntryName, false);
                entryData = new EntryData(entryName, zipFile, zipEntry);
                try {
                    this.scanEntry(entryData);
                }
                finally {
                    entryData.closeInputStream();
                }
            }
            catch (RuntimeException rex) {
                if (this.ignoreException) continue;
                ZipUtil.close(zipFile);
                throw rex;
            }
        }
        ZipUtil.close(zipFile);
    }

    protected void scanClassPath(File root) {
        File file;
        String rootPath = root.getAbsolutePath();
        if (!rootPath.endsWith(File.separator)) {
            rootPath = rootPath + File.separatorChar;
        }
        FindFile ff = new FindFile().includeDirs(false).recursive(true).searchPath(rootPath);
        while ((file = ff.nextFile()) != null) {
            String filePath = file.getAbsolutePath();
            try {
                if (StringUtil.endsWithIgnoreCase(filePath, CLASS_FILE_EXT)) {
                    this.scanClassFile(filePath, rootPath, file, true);
                    continue;
                }
                if (!this.includeResources) continue;
                this.scanClassFile(filePath, rootPath, file, false);
            }
            catch (RuntimeException rex) {
                if (this.ignoreException) continue;
                throw rex;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void scanClassFile(String filePath, String rootPath, File file, boolean isClass) {
        if (StringUtil.startsWithIgnoreCase(filePath, rootPath)) {
            String entryName = this.prepareEntryName(filePath.substring(rootPath.length()), isClass);
            EntryData entryData = new EntryData(entryName, file);
            try {
                this.scanEntry(entryData);
            }
            finally {
                entryData.closeInputStream();
            }
        }
    }

    protected String prepareEntryName(String name, boolean isClass) {
        String entryName = name;
        if (isClass) {
            entryName = name.substring(0, name.length() - 6);
            entryName = StringUtil.replaceChar(entryName, '/', '.');
            entryName = StringUtil.replaceChar(entryName, '\\', '.');
        } else {
            entryName = '/' + StringUtil.replaceChar(entryName, '\\', '/');
        }
        return entryName;
    }

    protected boolean acceptEntry(String entryName) {
        return this.rulesEntries.match(entryName);
    }

    protected void scanEntry(EntryData entryData) {
        if (!this.acceptEntry(entryData.name())) {
            return;
        }
        try {
            this.onEntry(entryData);
        }
        catch (Exception ex) {
            throw new FindFileException("Scan entry error: " + entryData, ex);
        }
    }

    public ClassScanner onEntry(Consumer<EntryData> entryDataConsumer) {
        this.entryDataConsumers.add(entryDataConsumer);
        return this;
    }

    protected void onEntry(EntryData entryData) {
        this.entryDataConsumers.accept(entryData);
    }

    public static byte[] bytecodeSignatureOfType(Class type) {
        String name = 'L' + type.getName().replace('.', '/') + ';';
        return name.getBytes();
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        try {
            return ClassLoaderUtil.loadClass(className);
        }
        catch (ClassNotFoundException | Error cnfex) {
            if (this.ignoreException) {
                return null;
            }
            throw cnfex;
        }
    }

    public void scan(URL ... urls) {
        for (URL path : urls) {
            this.scanUrl(path);
        }
    }

    public void scanDefaultClasspath() {
        this.scan(ClassLoaderUtil.getDefaultClasspath());
    }

    public void scan(File ... paths) {
        for (File path : paths) {
            this.scanPath(path);
        }
    }

    public void scan(String ... paths) {
        for (String path : paths) {
            this.scanPath(new File(path));
        }
    }

    public static class EntryData {
        private final File file;
        private final ZipFile zipFile;
        private final ZipEntry zipEntry;
        private final String name;
        private InputStream inputStream;

        EntryData(String name, ZipFile zipFile, ZipEntry zipEntry) {
            this.name = name;
            this.zipFile = zipFile;
            this.zipEntry = zipEntry;
            this.file = null;
            this.inputStream = null;
        }

        EntryData(String name, File file) {
            this.name = name;
            this.file = file;
            this.zipEntry = null;
            this.zipFile = null;
            this.inputStream = null;
        }

        public String name() {
            return this.name;
        }

        public boolean isArchive() {
            return this.zipFile != null;
        }

        public String archiveName() {
            if (this.zipFile != null) {
                return this.zipFile.getName();
            }
            return null;
        }

        public boolean isTypeSignatureInUse(byte[] bytes) {
            this.openInputStream();
            try {
                byte[] data = StreamUtil.readBytes(this.inputStream);
                int index = ArraysUtil.indexOf(data, bytes);
                return index != -1;
            }
            catch (IOException ioex) {
                throw new FindFileException("Read error", ioex);
            }
        }

        public InputStream openInputStream() {
            if (this.inputStream != null) {
                return this.inputStream;
            }
            if (this.zipFile != null && this.zipEntry != null) {
                try {
                    this.inputStream = this.zipFile.getInputStream(this.zipEntry);
                    return this.inputStream;
                }
                catch (IOException ioex) {
                    throw new FindFileException("Input stream error: '" + this.zipFile.getName() + "', entry: '" + this.zipEntry.getName() + "'.", ioex);
                }
            }
            if (this.file != null) {
                try {
                    this.inputStream = new FileInputStream(this.file);
                    return this.inputStream;
                }
                catch (FileNotFoundException fnfex) {
                    throw new FindFileException("Unable to open: " + this.file.getAbsolutePath(), fnfex);
                }
            }
            throw new FindFileException("Unable to open stream: " + this.name());
        }

        public void closeInputStream() {
            if (this.inputStream == null) {
                return;
            }
            StreamUtil.close(this.inputStream);
            this.inputStream = null;
        }

        public String toString() {
            return "EntryData{" + this.name + '\'' + '}';
        }
    }
}

