/*
 * Decompiled with CFR 0.152.
 */
package jodd.lagarto;

import jodd.lagarto.LagartoParserConfig;
import jodd.lagarto.ParsedDoctype;
import jodd.lagarto.ParsedTag;
import jodd.lagarto.Scanner;
import jodd.lagarto.State;
import jodd.lagarto.TagType;
import jodd.lagarto.TagVisitor;
import jodd.util.ArraysUtil;
import jodd.util.CharArraySequence;
import jodd.util.CharSequenceUtil;
import jodd.util.CharUtil;
import jodd.util.net.HtmlDecoder;

public class LagartoParser
extends Scanner {
    protected TagVisitor visitor;
    protected ParsedTag tag;
    protected ParsedDoctype doctype;
    protected long parsingTime;
    protected LagartoParserConfig config = new LagartoParserConfig();
    protected boolean parsing;
    protected State DATA_STATE = new State(){

        @Override
        public void parse() {
            while (true) {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.emitText();
                    LagartoParser.this.parsing = false;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '<') {
                    LagartoParser.this.emitText();
                    LagartoParser.this.state = LagartoParser.this.TAG_OPEN;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference();
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State TAG_OPEN = new State(){

        @Override
        public void parse() {
            LagartoParser.this.tag.start(LagartoParser.this.ndx);
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.textEmitChar('<');
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '!') {
                LagartoParser.this.state = LagartoParser.this.MARKUP_DECLARATION_OPEN;
                return;
            }
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.END_TAG_OPEN;
                return;
            }
            if (CharUtil.isAlpha(c)) {
                LagartoParser.this.state = LagartoParser.this.TAG_NAME;
                return;
            }
            if (LagartoParser.this.config.parseXmlTags && LagartoParser.this.match(XML)) {
                LagartoParser.this.ndx += XML.length() - 1;
                if (LagartoParser.this.xmlDeclaration == null) {
                    LagartoParser.this.xmlDeclaration = new XmlDeclaration();
                }
                LagartoParser.this.state = LagartoParser.this.xmlDeclaration.XML_BETWEEN;
                return;
            }
            if (c == '?') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.textEmitChar('<');
            --LagartoParser.this.ndx;
        }
    };
    protected State END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharUtil.isAlpha(c)) {
                LagartoParser.this.tag.setType(TagType.END);
                LagartoParser.this.state = LagartoParser.this.TAG_NAME;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
        }
    };
    protected State TAG_NAME = new State(){

        @Override
        public void parse() {
            block4: {
                char c;
                int nameNdx = LagartoParser.this.ndx;
                do {
                    ++LagartoParser.this.ndx;
                    if (LagartoParser.this.isEOF()) {
                        LagartoParser.this.errorEOF();
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        return;
                    }
                    c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                    if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                        LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                        LagartoParser.this.tag.setName(LagartoParser.this.charSequence(nameNdx, LagartoParser.this.ndx));
                    } else {
                        if (c != '/') continue;
                        LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                        LagartoParser.this.tag.setName(LagartoParser.this.charSequence(nameNdx, LagartoParser.this.ndx));
                    }
                    break block4;
                } while (c != '>');
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.tag.setName(LagartoParser.this.charSequence(nameNdx, LagartoParser.this.ndx));
                LagartoParser.this.emitTag();
            }
        }
    };
    protected State BEFORE_ATTRIBUTE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            if (CharSequenceUtil.equalsOne(c, ATTR_INVALID_1)) {
                LagartoParser.this.errorInvalidToken();
            }
            LagartoParser.this.state = LagartoParser.this.ATTRIBUTE_NAME;
        }
    };
    protected State ATTRIBUTE_NAME = new State(){

        @Override
        public void parse() {
            LagartoParser.this.attrStartNdx = LagartoParser.this.ndx;
            while (true) {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                    LagartoParser.this.attrEndNdx = LagartoParser.this.ndx;
                    LagartoParser.this.state = LagartoParser.this.AFTER_ATTRIBUTE_NAME;
                    return;
                }
                if (c == '/') {
                    LagartoParser.this.attrEndNdx = LagartoParser.this.ndx;
                    LagartoParser.this._addAttribute();
                    LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                    return;
                }
                if (c == '=') {
                    LagartoParser.this.attrEndNdx = LagartoParser.this.ndx;
                    LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_VALUE;
                    return;
                }
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.attrEndNdx = LagartoParser.this.ndx;
                    LagartoParser.this._addAttribute();
                    LagartoParser.this.emitTag();
                    return;
                }
                if (!CharSequenceUtil.equalsOne(c, ATTR_INVALID_2)) continue;
                LagartoParser.this.errorInvalidToken();
            }
        }
    };
    protected State AFTER_ATTRIBUTE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                return;
            }
            if (c == '=') {
                LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_VALUE;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            if (CharSequenceUtil.equalsOne(c, ATTR_INVALID_2)) {
                LagartoParser.this.errorInvalidToken();
            }
            LagartoParser.this._addAttribute();
            LagartoParser.this.state = LagartoParser.this.ATTRIBUTE_NAME;
        }
    };
    protected State BEFORE_ATTRIBUTE_VALUE = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '\"') {
                LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_SINGLE_QUOTED;
                return;
            }
            if (c == '&') {
                LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_UNQUOTED;
                --LagartoParser.this.ndx;
                return;
            }
            if (c == '>') {
                LagartoParser.this._addAttribute();
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            if (CharSequenceUtil.equalsOne(c, ATTR_INVALID_3)) {
                LagartoParser.this.errorInvalidToken();
            }
            LagartoParser.this.state = LagartoParser.this.ATTR_VALUE_UNQUOTED;
        }
    };
    protected State ATTR_VALUE_UNQUOTED = new State(){

        @Override
        public void parse() {
            LagartoParser.this.textStart();
            LagartoParser.this.textEmitChar(LagartoParser.this.input.charAt(LagartoParser.this.ndx));
            while (true) {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference('>');
                    continue;
                }
                if (c == '>') {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.emitTag();
                    return;
                }
                if (CharSequenceUtil.equalsOne(c, ATTR_INVALID_4)) {
                    LagartoParser.this.errorInvalidToken();
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State ATTR_VALUE_SINGLE_QUOTED = new State(){

        @Override
        public void parse() {
            LagartoParser.this.textStart();
            while (true) {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '\'') {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.AFTER_ATTRIBUTE_VALUE_QUOTED;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference('\'');
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State ATTR_VALUE_DOUBLE_QUOTED = new State(){

        @Override
        public void parse() {
            LagartoParser.this.textStart();
            while (true) {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '\"') {
                    LagartoParser.this._addAttributeWithValue();
                    LagartoParser.this.state = LagartoParser.this.AFTER_ATTRIBUTE_VALUE_QUOTED;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference('\"');
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State AFTER_ATTRIBUTE_VALUE_QUOTED = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                return;
            }
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
            --LagartoParser.this.ndx;
        }
    };
    protected State SELF_CLOSING_START_TAG = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '>') {
                LagartoParser.this.tag.setType(TagType.SELF_CLOSING);
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitTag();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
            --LagartoParser.this.ndx;
        }
    };
    protected State BOGUS_COMMENT = new State(){

        @Override
        public void parse() {
            int commentEndNdx = LagartoParser.this.find('>', LagartoParser.this.ndx, LagartoParser.this.total);
            if (commentEndNdx == -1) {
                commentEndNdx = LagartoParser.this.total;
            }
            LagartoParser.this.emitComment(LagartoParser.this.ndx, commentEndNdx);
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.ndx = commentEndNdx;
        }
    };
    protected State MARKUP_DECLARATION_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
                return;
            }
            if (LagartoParser.this.match(COMMENT_DASH)) {
                LagartoParser.this.state = LagartoParser.this.COMMENT_START;
                ++LagartoParser.this.ndx;
                return;
            }
            if (LagartoParser.this.matchUpperCase(T_DOCTYPE)) {
                LagartoParser.this.state = LagartoParser.this.DOCTYPE;
                LagartoParser.this.ndx += T_DOCTYPE.length() - 1;
                return;
            }
            if (LagartoParser.this.config.enableConditionalComments) {
                if (LagartoParser.this.match(CC_IF)) {
                    int ccEndNdx = LagartoParser.this.find(CC_END, LagartoParser.this.ndx + CC_IF.length(), LagartoParser.this.total);
                    if (ccEndNdx == -1) {
                        ccEndNdx = LagartoParser.this.total;
                    }
                    CharSequence expression = LagartoParser.this.charSequence(LagartoParser.this.ndx + 1, ccEndNdx);
                    LagartoParser.this.visitor.condComment(expression, true, false, false);
                    LagartoParser.this.ndx = ccEndNdx + 1;
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                if (LagartoParser.this.match(CC_ENDIF)) {
                    LagartoParser.this.ndx += CC_ENDIF.length();
                    int ccEndNdx = LagartoParser.this.find('>', LagartoParser.this.ndx, LagartoParser.this.total);
                    if (ccEndNdx == -1) {
                        ccEndNdx = LagartoParser.this.total;
                    }
                    if (LagartoParser.this.match(COMMENT_DASH, ccEndNdx - 2)) {
                        LagartoParser.this.visitor.condComment(_ENDIF, false, true, false);
                    } else {
                        LagartoParser.this.visitor.condComment(_ENDIF, false, false, false);
                    }
                    LagartoParser.this.ndx = ccEndNdx;
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
            }
            if (LagartoParser.this.config.parseXmlTags && LagartoParser.this.match(CDATA)) {
                LagartoParser.this.ndx += CDATA.length() - 1;
                if (LagartoParser.this.xmlDeclaration == null) {
                    LagartoParser.this.xmlDeclaration = new XmlDeclaration();
                }
                LagartoParser.this.state = LagartoParser.this.xmlDeclaration.CDATA;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_COMMENT;
        }
    };
    protected int rawTextStart;
    protected int rawTextEnd;
    protected CharSequence rawTagName;
    protected State RAWTEXT = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '<');
            LagartoParser.this.rawTextEnd = LagartoParser.this.ndx;
            LagartoParser.this.state = LagartoParser.this.RAWTEXT_LESS_THAN_SIGN;
        }
    };
    protected State RAWTEXT_LESS_THAN_SIGN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT_END_TAG_OPEN;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RAWTEXT;
        }
    };
    protected State RAWTEXT_END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharUtil.isAlpha(c)) {
                LagartoParser.this.state = LagartoParser.this.RAWTEXT_END_TAG_NAME;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RAWTEXT;
        }
    };
    protected State RAWTEXT_END_TAG_NAME = new State(){

        @Override
        public void parse() {
            char c;
            int rawtextEndTagNameStartNdx = LagartoParser.this.ndx;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                    return;
                }
                c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rawTagName, rawtextEndTagNameStartNdx, LagartoParser.this.ndx)) {
                        LagartoParser.this.textEmitChars(LagartoParser.this.rawTextStart, LagartoParser.this.rawTextEnd);
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                        LagartoParser.this.tag.start(LagartoParser.this.rawTextEnd);
                        LagartoParser.this.tag.setName(LagartoParser.this.charSequence(rawtextEndTagNameStartNdx, LagartoParser.this.ndx));
                        LagartoParser.this.tag.setType(TagType.END);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                    }
                    return;
                }
                if (c == '/') {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rawTagName, rawtextEndTagNameStartNdx, LagartoParser.this.ndx)) {
                        LagartoParser.this.textEmitChars(LagartoParser.this.rawTextStart, LagartoParser.this.rawTextEnd);
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                        LagartoParser.this.tag.start(LagartoParser.this.rawTextEnd);
                        LagartoParser.this.tag.setName(LagartoParser.this.charSequence(rawtextEndTagNameStartNdx, LagartoParser.this.ndx));
                        LagartoParser.this.tag.setType(TagType.SELF_CLOSING);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                    }
                    return;
                }
                if (c != '>') continue;
                if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rawTagName, rawtextEndTagNameStartNdx, LagartoParser.this.ndx)) {
                    LagartoParser.this.textEmitChars(LagartoParser.this.rawTextStart, LagartoParser.this.rawTextEnd);
                    LagartoParser.this.emitText();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.tag.start(LagartoParser.this.rawTextEnd);
                    LagartoParser.this.tag.setName(LagartoParser.this.charSequence(rawtextEndTagNameStartNdx, LagartoParser.this.ndx));
                    LagartoParser.this.tag.setType(TagType.END);
                    LagartoParser.this.tag.end(LagartoParser.this.ndx);
                    LagartoParser.this.emitTag();
                } else {
                    LagartoParser.this.state = LagartoParser.this.RAWTEXT;
                }
                return;
            } while (CharUtil.isAlpha(c));
            LagartoParser.this.state = LagartoParser.this.RAWTEXT;
        }
    };
    protected int rcdataTagStart = -1;
    protected CharSequence rcdataTagName;
    protected State RCDATA = new State(){

        @Override
        public void parse() {
            while (true) {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '<') {
                    LagartoParser.this.rcdataTagStart = LagartoParser.this.ndx;
                    LagartoParser.this.state = LagartoParser.this.RCDATA_LESS_THAN_SIGN;
                    return;
                }
                if (c == '&') {
                    LagartoParser.this.consumeCharacterReference();
                    continue;
                }
                LagartoParser.this.textEmitChar(c);
            }
        }
    };
    protected State RCDATA_LESS_THAN_SIGN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RCDATA;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.RCDATA_END_TAG_OPEN;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RCDATA;
            LagartoParser.this.textEmitChar('<');
            LagartoParser.this.textEmitChar(c);
        }
    };
    protected State RCDATA_END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.RCDATA;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharUtil.isAlpha(c)) {
                LagartoParser.this.state = LagartoParser.this.RCDATA_END_TAG_NAME;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.RCDATA;
            LagartoParser.this.textEmitChar('<');
            LagartoParser.this.textEmitChar('/');
            LagartoParser.this.textEmitChar(c);
        }
    };
    protected State RCDATA_END_TAG_NAME = new State(){

        @Override
        public void parse() {
            char c;
            int rcdataEndTagNameStartNdx = LagartoParser.this.ndx;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.RCDATA;
                    return;
                }
                c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rcdataTagName, rcdataEndTagNameStartNdx, LagartoParser.this.ndx)) {
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.BEFORE_ATTRIBUTE_NAME;
                        LagartoParser.this.tag.start(LagartoParser.this.rcdataTagStart);
                        LagartoParser.this.tag.setName(LagartoParser.this.charSequence(rcdataEndTagNameStartNdx, LagartoParser.this.ndx));
                        LagartoParser.this.tag.setType(TagType.END);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RCDATA;
                    }
                    return;
                }
                if (c == '/') {
                    if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rcdataTagName, rcdataEndTagNameStartNdx, LagartoParser.this.ndx)) {
                        LagartoParser.this.emitText();
                        LagartoParser.this.state = LagartoParser.this.SELF_CLOSING_START_TAG;
                        LagartoParser.this.tag.start(LagartoParser.this.rcdataTagStart);
                        LagartoParser.this.tag.setName(LagartoParser.this.charSequence(rcdataEndTagNameStartNdx, LagartoParser.this.ndx));
                        LagartoParser.this.tag.setType(TagType.SELF_CLOSING);
                    } else {
                        LagartoParser.this.state = LagartoParser.this.RCDATA;
                    }
                    return;
                }
                if (c != '>') continue;
                if (LagartoParser.this.isAppropriateTagName(LagartoParser.this.rcdataTagName, rcdataEndTagNameStartNdx, LagartoParser.this.ndx)) {
                    LagartoParser.this.emitText();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.tag.start(LagartoParser.this.rcdataTagStart);
                    LagartoParser.this.tag.setName(LagartoParser.this.charSequence(rcdataEndTagNameStartNdx, LagartoParser.this.ndx));
                    LagartoParser.this.tag.setType(TagType.END);
                    LagartoParser.this.tag.end(LagartoParser.this.ndx);
                    LagartoParser.this.emitTag();
                } else {
                    LagartoParser.this.state = LagartoParser.this.RCDATA;
                }
                return;
            } while (CharUtil.isAlpha(c));
            LagartoParser.this.state = LagartoParser.this.RCDATA;
        }
    };
    protected int commentStart;
    protected State COMMENT_START = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            LagartoParser.this.commentStart = LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.total);
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_START_DASH;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.ndx);
                return;
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State COMMENT_START_DASH = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.total);
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_END;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.ndx);
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State COMMENT = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.total);
                return;
            } while ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '-');
            LagartoParser.this.state = LagartoParser.this.COMMENT_END_DASH;
        }
    };
    protected State COMMENT_END_DASH = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.total);
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_END;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State COMMENT_END = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.total);
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.ndx - 2);
                return;
            }
            if (c == '!') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.COMMENT_END_BANG;
                return;
            }
            if (c == '-') {
                LagartoParser.this.errorInvalidToken();
            } else {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.COMMENT;
            }
        }
    };
    protected State COMMENT_END_BANG = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.total);
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '-') {
                LagartoParser.this.state = LagartoParser.this.COMMENT_END_DASH;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitComment(LagartoParser.this.commentStart, LagartoParser.this.ndx - 3);
                return;
            }
            LagartoParser.this.state = LagartoParser.this.COMMENT;
        }
    };
    protected State DOCTYPE = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_NAME;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_NAME;
            --LagartoParser.this.ndx;
        }
    };
    protected State BEFORE_DOCTYPE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.state = LagartoParser.this.DOCTYPE_NAME;
        }
    };
    protected State DOCTYPE_NAME = new State(){

        @Override
        public void parse() {
            char c;
            int nameStartNdx = LagartoParser.this.ndx;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.setName(LagartoParser.this.charSequence(nameStartNdx, LagartoParser.this.ndx));
                    LagartoParser.this.doctype.setQuirksMode(true);
                    LagartoParser.this.emitDoctype();
                    return;
                }
                c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (!CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) continue;
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCUMENT_NAME;
                LagartoParser.this.doctype.setName(LagartoParser.this.charSequence(nameStartNdx, LagartoParser.this.ndx));
                return;
            } while (c != '>');
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.setName(LagartoParser.this.charSequence(nameStartNdx, LagartoParser.this.ndx));
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCUMENT_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            }
            if (LagartoParser.this.matchUpperCase(A_PUBLIC)) {
                LagartoParser.this.ndx += A_PUBLIC.length() - 1;
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_PUBLIC_KEYWORD;
                return;
            }
            if (LagartoParser.this.matchUpperCase(A_SYSTEM)) {
                LagartoParser.this.ndx += A_SYSTEM.length() - 1;
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_SYSTEM_KEYWORD;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            LagartoParser.this.doctype.setQuirksMode(true);
        }
    };
    protected int doctypeIdNameStart;
    protected State AFTER_DOCTYPE_PUBLIC_KEYWORD = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_PUBLIC_IDENTIFIER;
                return;
            }
            if (c == '\"') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            LagartoParser.this.doctype.setQuirksMode(true);
        }
    };
    protected State BEFORE_DOCTYPE_PUBLIC_IDENTIFIER = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '\"') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State DOCTYPE_PUBLIC_IDENTIFIER_DOUBLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.doctype.setPublicIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.setQuirksMode(true);
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '\"') continue;
                LagartoParser.this.doctype.setPublicIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.setPublicIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.emitDoctype();
        }
    };
    protected State DOCTYPE_PUBLIC_IDENTIFIER_SINGLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.doctype.setPublicIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.setQuirksMode(true);
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '\'') continue;
                LagartoParser.this.doctype.setPublicIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_PUBLIC_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.setPublicIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCTYPE_PUBLIC_IDENTIFIER = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS;
                return;
            }
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            }
            if (c == '\"') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State BETWEEN_DOCTYPE_PUBLIC_AND_SYSTEM_IDENTIFIERS = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '>') {
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            }
            if (c == '\"') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State BOGUS_DOCTYPE = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '>');
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCTYPE_SYSTEM_KEYWORD = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                LagartoParser.this.state = LagartoParser.this.BEFORE_DOCTYPE_SYSTEM_IDENTIFIER;
                return;
            }
            if (c == '\"') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            LagartoParser.this.doctype.setQuirksMode(true);
        }
    };
    protected State BEFORE_DOCTYPE_SYSTEM_IDENTIFIER = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.errorEOF();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.emitDoctype();
                return;
            } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
            if (c == '\"') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED;
                return;
            }
            if (c == '\'') {
                LagartoParser.this.doctypeIdNameStart = LagartoParser.this.ndx + 1;
                LagartoParser.this.state = LagartoParser.this.DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED;
                return;
            }
            if (c == '>') {
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                LagartoParser.this.doctype.setQuirksMode(true);
                LagartoParser.this.emitDoctype();
                return;
            }
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
        }
    };
    protected State DOCTYPE_SYSTEM_IDENTIFIER_DOUBLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.doctype.setSystemIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.setQuirksMode(true);
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '\"') continue;
                LagartoParser.this.doctype.setSystemIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.setSystemIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.emitDoctype();
        }
    };
    protected State DOCTYPE_SYSTEM_IDENTIFIER_SINGLE_QUOTED = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.doctype.setSystemIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.setQuirksMode(true);
                    LagartoParser.this.emitDoctype();
                }
                if ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '\'') continue;
                LagartoParser.this.doctype.setSystemIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
                LagartoParser.this.state = LagartoParser.this.AFTER_DOCTYPE_SYSTEM_IDENTIFIER;
                return;
            } while (c != '>');
            LagartoParser.this.doctype.setSystemIdentifier(LagartoParser.this.charSequence(LagartoParser.this.doctypeIdNameStart, LagartoParser.this.ndx));
            LagartoParser.this.errorInvalidToken();
            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            LagartoParser.this.doctype.setQuirksMode(true);
            LagartoParser.this.emitDoctype();
        }
    };
    protected State AFTER_DOCTYPE_SYSTEM_IDENTIFIER = new State(){

        @Override
        public void parse() {
            while (true) {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.doctype.setQuirksMode(true);
                    LagartoParser.this.emitDoctype();
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) continue;
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.emitDoctype();
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.BOGUS_DOCTYPE;
            }
        }
    };
    protected int scriptStartNdx = -1;
    protected int scriptEndNdx = -1;
    protected int scriptEndTagName = -1;
    protected State SCRIPT_DATA = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (!LagartoParser.this.isEOF()) continue;
                LagartoParser.this.emitScript(LagartoParser.this.scriptStartNdx, LagartoParser.this.total);
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                return;
            } while ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != '<');
            LagartoParser.this.scriptEndNdx = LagartoParser.this.ndx;
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA_LESS_THAN_SIGN;
        }
    };
    protected State SCRIPT_DATA_LESS_THAN_SIGN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                --LagartoParser.this.ndx;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (c == '/') {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA_END_TAG_OPEN;
                return;
            }
            if (c == '!') {
                if (LagartoParser.this.scriptEscape == null) {
                    LagartoParser.this.scriptEscape = new ScriptEscape();
                }
                LagartoParser.this.state = LagartoParser.this.scriptEscape.SCRIPT_DATA_ESCAPE_START;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
        }
    };
    protected State SCRIPT_DATA_END_TAG_OPEN = new State(){

        @Override
        public void parse() {
            ++LagartoParser.this.ndx;
            if (LagartoParser.this.isEOF()) {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                --LagartoParser.this.ndx;
                return;
            }
            char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
            if (CharUtil.isAlpha(c)) {
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA_END_TAG_NAME;
                LagartoParser.this.scriptEndTagName = LagartoParser.this.ndx;
                return;
            }
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
        }
    };
    protected State SCRIPT_DATA_END_TAG_NAME = new State(){

        @Override
        public void parse() {
            char c;
            do {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.ndx) ? LagartoParser.this.BEFORE_ATTRIBUTE_NAME : LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                if (c == '/') {
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.ndx) ? LagartoParser.this.SELF_CLOSING_START_TAG : LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                if (c != '>') continue;
                if (LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.ndx)) {
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    LagartoParser.this.emitScript(LagartoParser.this.scriptStartNdx, LagartoParser.this.scriptEndNdx);
                } else {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                }
                return;
            } while (CharUtil.isAlpha(c));
            LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
        }
    };
    protected ScriptEscape scriptEscape = null;
    protected XmlDeclaration xmlDeclaration = null;
    protected char[] text;
    protected int textLen;
    protected int attrStartNdx = -1;
    protected int attrEndNdx = -1;
    protected State state = this.DATA_STATE;
    private static final CharSequence TAG_WHITESPACES = CharArraySequence.of('\t', '\n', '\r', ' ');
    private static final CharSequence TAG_WHITESPACES_OR_END = CharArraySequence.of('\t', '\n', '\r', ' ', '/', '>');
    private static final CharSequence CONTINUE_CHARS = CharArraySequence.of('\t', '\n', '\r', ' ', '<', '&');
    private static final CharSequence ATTR_INVALID_1 = CharArraySequence.of('\"', '\'', '<', '=');
    private static final CharSequence ATTR_INVALID_2 = CharArraySequence.of('\"', '\'', '<');
    private static final CharSequence ATTR_INVALID_3 = CharArraySequence.of('<', '=', '`');
    private static final CharSequence ATTR_INVALID_4 = CharArraySequence.of('\"', '\'', '<', '=', '`');
    private static final CharSequence COMMENT_DASH = CharArraySequence.of('-', '-');
    private static final CharSequence T_DOCTYPE = CharArraySequence.of('D', 'O', 'C', 'T', 'Y', 'P', 'E');
    private static final CharSequence T_SCRIPT = CharArraySequence.of('s', 'c', 'r', 'i', 'p', 't');
    private static final CharSequence T_XMP = CharArraySequence.of('x', 'm', 'p');
    private static final CharSequence T_STYLE = CharArraySequence.of('s', 't', 'y', 'l', 'e');
    private static final CharSequence T_IFRAME = CharArraySequence.of('i', 'f', 'r', 'a', 'm', 'e');
    private static final CharSequence T_NOFRAMES = CharArraySequence.of('n', 'o', 'f', 'r', 'a', 'm', 'e', 's');
    private static final CharSequence T_NOEMBED = CharArraySequence.of('n', 'o', 'e', 'm', 'b', 'e', 'd');
    private static final CharSequence T_NOSCRIPT = CharArraySequence.of('n', 'o', 's', 'c', 'r', 'i', 'p', 't');
    private static final CharSequence T_TEXTAREA = CharArraySequence.of('t', 'e', 'x', 't', 'a', 'r', 'e', 'a');
    private static final CharSequence T_TITLE = CharArraySequence.of('t', 'i', 't', 'l', 'e');
    private static final CharSequence A_PUBLIC = CharArraySequence.of('P', 'U', 'B', 'L', 'I', 'C');
    private static final CharSequence A_SYSTEM = CharArraySequence.of('S', 'Y', 'S', 'T', 'E', 'M');
    private static final CharSequence CDATA = CharArraySequence.of('[', 'C', 'D', 'A', 'T', 'A', '[');
    private static final CharSequence CDATA_END = CharArraySequence.of(']', ']', '>');
    private static final CharSequence XML = CharArraySequence.of('?', 'x', 'm', 'l');
    private static final CharSequence XML_VERSION = CharArraySequence.of('v', 'e', 'r', 's', 'i', 'o', 'n');
    private static final CharSequence XML_ENCODING = CharArraySequence.of('e', 'n', 'c', 'o', 'd', 'i', 'n', 'g');
    private static final CharSequence XML_STANDALONE = CharArraySequence.of('s', 't', 'a', 'n', 'd', 'a', 'l', 'o', 'n', 'e');
    private static final CharSequence CC_IF = CharArraySequence.of('[', 'i', 'f', ' ');
    private static final CharSequence CC_ENDIF = CharArraySequence.of('[', 'e', 'n', 'd', 'i', 'f', ']');
    private static final CharSequence CC_ENDIF2 = CharArraySequence.of('<', '!', '[', 'e', 'n', 'd', 'i', 'f', ']');
    private static final CharSequence CC_END = CharArraySequence.of(']', '>');
    private static final CharSequence[] RAWTEXT_TAGS = new CharSequence[]{T_XMP, T_STYLE, T_IFRAME, T_NOEMBED, T_NOFRAMES, T_NOSCRIPT, T_SCRIPT};
    private static final CharSequence[] RCDATA_TAGS = new CharSequence[]{T_TEXTAREA, T_TITLE};
    private static final char REPLACEMENT_CHAR = '\ufffd';
    private static final CharSequence INVALID_CHARS = CharArraySequence.of('\u000b', '\ufffe', '\uffff');
    private static final CharSequence _ENDIF = "endif";

    public LagartoParser(char[] charArray) {
        this.initialize(CharArraySequence.of(charArray));
    }

    public LagartoParser(CharSequence string) {
        this.initialize(string);
    }

    @Override
    protected void initialize(CharSequence input) {
        super.initialize(input);
        this.tag = new ParsedTag();
        this.doctype = new ParsedDoctype();
        this.text = new char[1024];
        this.textLen = 0;
        this.parsingTime = -1L;
    }

    public LagartoParserConfig getConfig() {
        return this.config;
    }

    public void setConfig(LagartoParserConfig config) {
        this.config = config;
    }

    public void parse(TagVisitor visitor) {
        this.tag.init(this.config.caseSensitive);
        this.parsingTime = System.currentTimeMillis();
        this.visitor = visitor;
        visitor.start();
        this.parsing = true;
        while (this.parsing) {
            this.state.parse();
        }
        this.emitText();
        visitor.end();
        this.parsingTime = System.currentTimeMillis() - this.parsingTime;
    }

    public long getParsingTime() {
        return this.parsingTime;
    }

    protected void consumeCharacterReference(char allowedChar) {
        ++this.ndx;
        if (this.isEOF()) {
            return;
        }
        char c = this.input.charAt(this.ndx);
        if (c == allowedChar) {
            --this.ndx;
            return;
        }
        this._consumeAttrCharacterReference();
    }

    protected void consumeCharacterReference() {
        ++this.ndx;
        if (this.isEOF()) {
            return;
        }
        this._consumeCharacterReference();
    }

    private void _consumeCharacterReference() {
        int unconsumeNdx = this.ndx - 1;
        char c = this.input.charAt(this.ndx);
        if (CharSequenceUtil.equalsOne(c, CONTINUE_CHARS)) {
            this.ndx = unconsumeNdx;
            this.textEmitChar('&');
            return;
        }
        if (c == '#') {
            this._consumeNumber(unconsumeNdx);
        } else {
            String name = HtmlDecoder.detectName(this.input, this.ndx);
            if (name == null) {
                this.errorCharReference();
                this.textEmitChar('&');
                this.ndx = unconsumeNdx;
                return;
            }
            this.ndx += name.length();
            this.textEmitChars(HtmlDecoder.lookup(name));
            c = this.input.charAt(this.ndx);
            if (c != ';') {
                this.errorCharReference();
                --this.ndx;
            }
        }
    }

    private void _consumeAttrCharacterReference() {
        int unconsumeNdx = this.ndx - 1;
        char c = this.input.charAt(this.ndx);
        if (CharSequenceUtil.equalsOne(c, CONTINUE_CHARS)) {
            this.ndx = unconsumeNdx;
            this.textEmitChar('&');
            return;
        }
        if (c == '#') {
            this._consumeNumber(unconsumeNdx);
        } else {
            String name = HtmlDecoder.detectName(this.input, this.ndx);
            if (name == null) {
                this.errorCharReference();
                this.textEmitChar('&');
                this.ndx = unconsumeNdx;
                return;
            }
            this.ndx += name.length();
            c = this.input.charAt(this.ndx);
            if (c == ';') {
                this.textEmitChars(HtmlDecoder.lookup(name));
            } else {
                this.textEmitChar('&');
                this.ndx = unconsumeNdx;
            }
        }
    }

    private void _consumeNumber(int unconsumeNdx) {
        ++this.ndx;
        if (this.isEOF()) {
            this.ndx = unconsumeNdx;
            return;
        }
        char c = this.input.charAt(this.ndx);
        int value = 0;
        int digitCount = 0;
        if (c == 'X' || c == 'x') {
            while (true) {
                ++this.ndx;
                if (this.isEOF()) {
                    this.ndx = unconsumeNdx;
                    return;
                }
                c = this.input.charAt(this.ndx);
                if (CharUtil.isDigit(c)) {
                    value *= 16;
                    value += c - 48;
                    ++digitCount;
                    continue;
                }
                if (c >= 'a' && c <= 'f') {
                    value *= 16;
                    value += c - 97 + 10;
                    ++digitCount;
                    continue;
                }
                if (c >= 'A' && c <= 'F') {
                    value *= 16;
                    value += c - 65 + 10;
                    ++digitCount;
                    continue;
                }
                break;
            }
        } else {
            while (CharUtil.isDigit(c)) {
                value *= 10;
                value += c - 48;
                ++this.ndx;
                if (this.isEOF()) {
                    this.ndx = unconsumeNdx;
                    return;
                }
                c = this.input.charAt(this.ndx);
                ++digitCount;
            }
        }
        if (digitCount == 0) {
            this.errorCharReference();
            this.ndx = unconsumeNdx;
            return;
        }
        if (c != ';') {
            this.errorCharReference();
            --this.ndx;
        }
        boolean isErr = true;
        switch (value) {
            case 0: {
                c = '\ufffd';
                break;
            }
            case 128: {
                c = '\u20ac';
                break;
            }
            case 129: {
                c = '\u0081';
                break;
            }
            case 130: {
                c = '\u201a';
                break;
            }
            case 131: {
                c = '\u0192';
                break;
            }
            case 132: {
                c = '\u201e';
                break;
            }
            case 133: {
                c = '\u2026';
                break;
            }
            case 134: {
                c = '\u2020';
                break;
            }
            case 135: {
                c = '\u2021';
                break;
            }
            case 136: {
                c = '\u02c6';
                break;
            }
            case 137: {
                c = '\u2030';
                break;
            }
            case 138: {
                c = '\u0160';
                break;
            }
            case 139: {
                c = '\u2039';
                break;
            }
            case 140: {
                c = '\u0152';
                break;
            }
            case 141: {
                c = '\u008d';
                break;
            }
            case 142: {
                c = '\u017d';
                break;
            }
            case 143: {
                c = '\u008f';
                break;
            }
            case 144: {
                c = '\u0090';
                break;
            }
            case 145: {
                c = '\u2018';
                break;
            }
            case 146: {
                c = '\u2019';
                break;
            }
            case 147: {
                c = '\u201c';
                break;
            }
            case 148: {
                c = '\u201d';
                break;
            }
            case 149: {
                c = '\u2022';
                break;
            }
            case 150: {
                c = '\u2013';
                break;
            }
            case 151: {
                c = '\u2014';
                break;
            }
            case 152: {
                c = '\u02dc';
                break;
            }
            case 153: {
                c = '\u2122';
                break;
            }
            case 154: {
                c = '\u0161';
                break;
            }
            case 155: {
                c = '\u203a';
                break;
            }
            case 156: {
                c = '\u0153';
                break;
            }
            case 157: {
                c = '\u009d';
                break;
            }
            case 158: {
                c = '\u017e';
                break;
            }
            case 159: {
                c = '\u0178';
                break;
            }
            default: {
                isErr = false;
            }
        }
        if (isErr) {
            this.errorCharReference();
            this.textEmitChar(c);
            return;
        }
        if (value >= 55296 && value <= 3583 || value > 0x10FFFF) {
            this.errorCharReference();
            this.textEmitChar('\ufffd');
            return;
        }
        c = (char)value;
        this.textEmitChar(c);
        if (c >= '\u0001' && c <= '\b' || c >= '\r' && c <= '\u001f' || c >= '\u007f' && c <= '\u009f' || c >= '\ufdd0' && c <= '\ufdef') {
            this.errorCharReference();
            return;
        }
        if (CharSequenceUtil.equalsOne(c, INVALID_CHARS)) {
            this.errorCharReference();
        }
    }

    private void ensureCapacity() {
        if (this.textLen == this.text.length) {
            this.text = ArraysUtil.resize(this.text, this.textLen << 1);
        }
    }

    private void ensureCapacity(int growth) {
        int desiredLen = this.textLen + growth;
        if (desiredLen > this.text.length) {
            this.text = ArraysUtil.resize(this.text, Math.max(this.textLen << 1, desiredLen));
        }
    }

    protected void textEmitChar(char c) {
        this.ensureCapacity();
        this.text[this.textLen++] = c;
    }

    protected void textStart() {
        this.textLen = 0;
    }

    protected void textEmitChars(int from, int to) {
        this.ensureCapacity(to - from);
        while (from < to) {
            this.text[this.textLen++] = this.input.charAt(from++);
        }
    }

    protected void textEmitChars(char[] buffer) {
        this.ensureCapacity(buffer.length);
        for (char aBuffer : buffer) {
            this.text[this.textLen++] = aBuffer;
        }
    }

    protected CharSequence textWrap() {
        if (this.textLen == 0) {
            return CharArraySequence.EMPTY;
        }
        return new String(this.text, 0, this.textLen);
    }

    private void _addAttribute() {
        this._addAttribute(this.charSequence(this.attrStartNdx, this.attrEndNdx), null);
    }

    private void _addAttributeWithValue() {
        this._addAttribute(this.charSequence(this.attrStartNdx, this.attrEndNdx), this.textWrap().toString());
    }

    private void _addAttribute(CharSequence attrName, CharSequence attrValue) {
        if (this.tag.getType() == TagType.END) {
            this._error("Ignored end tag attribute");
        } else if (this.tag.hasAttribute(attrName)) {
            this._error("Ignored duplicated attribute: " + attrName);
        } else {
            this.tag.addAttribute(attrName, attrValue);
        }
        this.attrStartNdx = -1;
        this.attrEndNdx = -1;
        this.textLen = 0;
    }

    protected void emitTag() {
        this.tag.end(this.ndx + 1);
        if (this.config.calculatePosition) {
            this.tag.setPosition(this.position(this.tag.getTagPosition()));
        }
        if (this.tag.getType().isStartingTag()) {
            if (this.tag.matchTagName(T_SCRIPT)) {
                this.scriptStartNdx = this.ndx + 1;
                this.state = this.SCRIPT_DATA;
                return;
            }
            if (this.config.enableRawTextModes) {
                for (CharSequence rawtextTagName : RAWTEXT_TAGS) {
                    if (!this.tag.matchTagName(rawtextTagName)) continue;
                    this.tag.setRawTag(true);
                    this.state = this.RAWTEXT;
                    this.rawTextStart = this.ndx + 1;
                    this.rawTagName = rawtextTagName;
                    break;
                }
                for (CharSequence rcdataTextTagName : RCDATA_TAGS) {
                    if (!this.tag.matchTagName(rcdataTextTagName)) continue;
                    this.state = this.RCDATA;
                    this.rcdataTagStart = this.ndx + 1;
                    this.rcdataTagName = rcdataTextTagName;
                    break;
                }
            }
            this.tag.increaseDeepLevel();
        }
        this.visitor.tag(this.tag);
        if (this.tag.getType().isEndingTag()) {
            this.tag.decreaseDeepLevel();
        }
    }

    protected void emitComment(int from, int to) {
        if (this.config.enableConditionalComments) {
            if (this.match(CC_IF, from)) {
                int endBracketNdx = this.find(']', from + 3, to);
                CharSequence expression = this.charSequence(from + 1, endBracketNdx);
                this.ndx = endBracketNdx + 1;
                char c = this.input.charAt(this.ndx);
                if (c != '>') {
                    this.errorInvalidToken();
                }
                this.visitor.condComment(expression, true, true, false);
                this.state = this.DATA_STATE;
                return;
            }
            if (to > CC_ENDIF2.length() && this.match(CC_ENDIF2, to - CC_ENDIF2.length())) {
                this.visitor.condComment(_ENDIF, false, true, true);
                this.state = this.DATA_STATE;
                return;
            }
        }
        CharSequence comment = this.charSequence(from, to);
        this.visitor.comment(comment);
        this.commentStart = -1;
    }

    protected void emitText() {
        if (this.textLen != 0) {
            this.visitor.text(this.textWrap());
        }
        this.textLen = 0;
    }

    protected void emitScript(int from, int to) {
        this.tag.increaseDeepLevel();
        this.tag.setRawTag(true);
        this.visitor.script(this.tag, this.charSequence(from, to));
        this.tag.decreaseDeepLevel();
        this.scriptStartNdx = -1;
        this.scriptEndNdx = -1;
    }

    protected void emitDoctype() {
        this.visitor.doctype(this.doctype);
        this.doctype.reset();
    }

    protected void emitXml() {
        this.visitor.xml(this.xmlDeclaration.version, this.xmlDeclaration.encoding, this.xmlDeclaration.standalone);
        this.xmlDeclaration.reset();
    }

    protected void emitCData(CharSequence charSequence) {
        this.visitor.cdata(charSequence);
    }

    protected void errorEOF() {
        this._error("Parse error: EOF");
    }

    protected void errorInvalidToken() {
        this._error("Parse error: invalid token");
    }

    protected void errorCharReference() {
        this._error("Parse error: invalid character reference");
    }

    protected void _error(String message) {
        if (this.config.calculatePosition) {
            Scanner.Position currentPosition = this.position(this.ndx);
            message = message.concat(" ").concat(currentPosition.toString());
        } else {
            message = message.concat(" [@").concat(Integer.toString(this.ndx)).concat("]");
        }
        this.visitor.error(message);
    }

    private boolean isAppropriateTagName(CharSequence lowerCaseNameToMatch, int from, int to) {
        int len = to - from;
        if (len != lowerCaseNameToMatch.length()) {
            return false;
        }
        int i = from;
        int k = 0;
        while (i < to) {
            char c = this.input.charAt(i);
            if ((c = CharUtil.toLowerAscii(c)) != lowerCaseNameToMatch.charAt(k)) {
                return false;
            }
            ++i;
            ++k;
        }
        return true;
    }

    protected class XmlDeclaration {
        protected int xmlAttrCount = 0;
        protected int xmlAttrStartNdx = -1;
        protected CharSequence version;
        protected CharSequence encoding;
        protected CharSequence standalone;
        protected char attrQuote;
        protected State XML_BETWEEN = new State(){

            @Override
            public void parse() {
                while (true) {
                    ++LagartoParser.this.ndx;
                    if (LagartoParser.this.isEOF()) {
                        LagartoParser.this.errorEOF();
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        return;
                    }
                    char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                    if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) continue;
                    if (c == '?') {
                        LagartoParser.this.state = XmlDeclaration.this.XML_CLOSE;
                        return;
                    }
                    switch (XmlDeclaration.this.xmlAttrCount) {
                        case 0: {
                            if (!LagartoParser.this.match(XML_VERSION)) break;
                            LagartoParser.this.ndx += XML_VERSION.length() - 1;
                            LagartoParser.this.state = XmlDeclaration.this.AFTER_XML_ATTRIBUTE_NAME;
                            return;
                        }
                        case 1: {
                            if (!LagartoParser.this.match(XML_ENCODING)) break;
                            LagartoParser.this.ndx += XML_ENCODING.length() - 1;
                            LagartoParser.this.state = XmlDeclaration.this.AFTER_XML_ATTRIBUTE_NAME;
                            return;
                        }
                        case 2: {
                            if (!LagartoParser.this.match(XML_STANDALONE)) break;
                            LagartoParser.this.ndx += XML_STANDALONE.length() - 1;
                            LagartoParser.this.state = XmlDeclaration.this.AFTER_XML_ATTRIBUTE_NAME;
                            return;
                        }
                    }
                    LagartoParser.this.errorInvalidToken();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                }
            }
        };
        protected State AFTER_XML_ATTRIBUTE_NAME = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.ndx;
                    if (!LagartoParser.this.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
                if (c == '=') {
                    LagartoParser.this.state = XmlDeclaration.this.BEFORE_XML_ATTRIBUTE_VALUE;
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };
        protected State BEFORE_XML_ATTRIBUTE_VALUE = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.ndx;
                    if (!LagartoParser.this.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while (CharSequenceUtil.equalsOne(c = LagartoParser.this.input.charAt(LagartoParser.this.ndx), TAG_WHITESPACES));
                if (c == '\"' || c == '\'') {
                    LagartoParser.this.state = XmlDeclaration.this.XML_ATTRIBUTE_VALUE;
                    XmlDeclaration.this.attrQuote = c;
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };
        protected State XML_ATTRIBUTE_VALUE = new State(){

            @Override
            public void parse() {
                char c;
                XmlDeclaration.this.xmlAttrStartNdx = LagartoParser.this.ndx + 1;
                do {
                    ++LagartoParser.this.ndx;
                    if (!LagartoParser.this.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) != XmlDeclaration.this.attrQuote);
                CharSequence value = LagartoParser.this.charSequence(XmlDeclaration.this.xmlAttrStartNdx, LagartoParser.this.ndx);
                switch (XmlDeclaration.this.xmlAttrCount) {
                    case 0: {
                        XmlDeclaration.this.version = value;
                        break;
                    }
                    case 1: {
                        XmlDeclaration.this.encoding = value;
                        break;
                    }
                    case 2: {
                        XmlDeclaration.this.standalone = value;
                    }
                }
                ++XmlDeclaration.this.xmlAttrCount;
                LagartoParser.this.state = XmlDeclaration.this.XML_BETWEEN;
            }
        };
        protected State XML_CLOSE = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '>') {
                    LagartoParser.this.emitXml();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                LagartoParser.this.errorInvalidToken();
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };
        protected State CDATA = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                int cdataEndNdx = LagartoParser.this.find(CDATA_END, LagartoParser.this.ndx, LagartoParser.this.total);
                if (cdataEndNdx == -1) {
                    cdataEndNdx = LagartoParser.this.total;
                }
                CharSequence cdata = LagartoParser.this.charSequence(LagartoParser.this.ndx, cdataEndNdx);
                LagartoParser.this.emitCData(cdata);
                LagartoParser.this.ndx = cdataEndNdx + 2;
                LagartoParser.this.state = LagartoParser.this.DATA_STATE;
            }
        };

        protected XmlDeclaration() {
        }

        protected void reset() {
            this.xmlAttrCount = 0;
            this.xmlAttrStartNdx = -1;
            this.standalone = null;
            this.encoding = null;
            this.version = null;
        }
    }

    protected class ScriptEscape {
        protected int doubleEscapedNdx = -1;
        protected int doubleEscapedEndTag = -1;
        protected State SCRIPT_DATA_ESCAPE_START = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    --LagartoParser.this.ndx;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPE_START_DASH;
                    return;
                }
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
            }
        };
        protected State SCRIPT_DATA_ESCAPE_START_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH_DASH;
                    return;
                }
                LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_DASH_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '-') {
                    return;
                }
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '/') {
                    ScriptEscape.this.doubleEscapedNdx = -1;
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_END_TAG_OPEN;
                    return;
                }
                if (CharUtil.isAlpha(c)) {
                    ScriptEscape.this.doubleEscapedNdx = LagartoParser.this.ndx;
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPE_START;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED = new State(){

            @Override
            public void parse() {
                block2: {
                    char c;
                    do {
                        ++LagartoParser.this.ndx;
                        if (LagartoParser.this.isEOF()) {
                            LagartoParser.this.errorEOF();
                            LagartoParser.this.emitScript(LagartoParser.this.scriptStartNdx, LagartoParser.this.total);
                            LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                            return;
                        }
                        c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                        if (c == '-') break block2;
                    } while (c != '<');
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH_DASH;
                    return;
                }
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_DASH_DASH;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_END_TAG_OPEN = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (CharUtil.isAlpha(c)) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED_END_TAG_NAME;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_ESCAPED_END_TAG_NAME = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.ndx;
                    if (LagartoParser.this.isEOF()) {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                    if (CharSequenceUtil.equalsOne(c, TAG_WHITESPACES)) {
                        LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.ndx) ? LagartoParser.this.BEFORE_ATTRIBUTE_NAME : ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    if (c == '/') {
                        LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.ndx) ? LagartoParser.this.SELF_CLOSING_START_TAG : ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    if (c != '>') continue;
                    if (LagartoParser.this.isAppropriateTagName(T_SCRIPT, LagartoParser.this.scriptEndTagName, LagartoParser.this.ndx)) {
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        LagartoParser.this.emitTag();
                    } else {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    }
                    return;
                } while (CharUtil.isAlpha(c));
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPE_START = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.ndx;
                    if (LagartoParser.this.isEOF()) {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                        return;
                    }
                    c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                    if (!CharSequenceUtil.equalsOne(c, TAG_WHITESPACES_OR_END)) continue;
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, ScriptEscape.this.doubleEscapedNdx, LagartoParser.this.ndx) ? ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED : ScriptEscape.this.SCRIPT_DATA_ESCAPED;
                    return;
                } while (CharUtil.isAlpha(c));
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.ndx;
                    if (LagartoParser.this.isEOF()) {
                        LagartoParser.this.errorEOF();
                        LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                        return;
                    }
                    c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                    if (c != '-') continue;
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_DASH;
                    return;
                } while (c != '<');
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED_DASH = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '-') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH;
                    return;
                }
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED_DASH_DASH = new State(){

            @Override
            public void parse() {
                char c;
                do {
                    ++LagartoParser.this.ndx;
                    if (!LagartoParser.this.isEOF()) continue;
                    LagartoParser.this.errorEOF();
                    LagartoParser.this.state = LagartoParser.this.DATA_STATE;
                    return;
                } while ((c = LagartoParser.this.input.charAt(LagartoParser.this.ndx)) == '-');
                if (c == '<') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN;
                    return;
                }
                if (c == '>') {
                    LagartoParser.this.state = LagartoParser.this.SCRIPT_DATA;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPED_LESS_THAN_SIGN = new State(){

            @Override
            public void parse() {
                ++LagartoParser.this.ndx;
                if (LagartoParser.this.isEOF()) {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
                    return;
                }
                char c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                if (c == '/') {
                    LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPE_END;
                    return;
                }
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };
        protected State SCRIPT_DATA_DOUBLE_ESCAPE_END = new State(){

            @Override
            public void parse() {
                char c;
                ScriptEscape.this.doubleEscapedEndTag = LagartoParser.this.ndx + 1;
                do {
                    ++LagartoParser.this.ndx;
                    if (LagartoParser.this.isEOF()) {
                        LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
                        return;
                    }
                    c = LagartoParser.this.input.charAt(LagartoParser.this.ndx);
                    if (!CharSequenceUtil.equalsOne(c, TAG_WHITESPACES_OR_END)) continue;
                    LagartoParser.this.state = LagartoParser.this.isAppropriateTagName(T_SCRIPT, ScriptEscape.this.doubleEscapedEndTag, LagartoParser.this.ndx) ? ScriptEscape.this.SCRIPT_DATA_ESCAPED : ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
                    return;
                } while (CharUtil.isAlpha(c));
                LagartoParser.this.state = ScriptEscape.this.SCRIPT_DATA_DOUBLE_ESCAPED;
            }
        };

        protected ScriptEscape() {
        }
    }
}

