/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.result;

import jodd.json.JsonSerializer;
import jodd.madvoc.meta.RenderWith;
import jodd.madvoc.result.JsonActionResult;
import jodd.util.net.HttpStatus;

@RenderWith(value=JsonActionResult.class)
public class JsonResult {
    private final String body;
    private int status = 200;
    private String message = "OK";

    public static JsonResult of(String json) {
        return new JsonResult(json);
    }

    public static JsonResult of(Object object) {
        String json = JsonSerializer.create().deep(true).serialize(object);
        return new JsonResult(json);
    }

    public static JsonResult of(HttpStatus httpStatus) {
        return JsonResult.empty().status(httpStatus);
    }

    public static JsonResult empty() {
        return new JsonResult("");
    }

    public JsonResult(String body) {
        this.body = body;
    }

    public JsonResult status(int status) {
        this.status = status;
        this.message = this.message;
        return this;
    }

    public JsonResult status(HttpStatus httpStatus) {
        this.status = httpStatus.status();
        this.message = httpStatus.message();
        return this;
    }

    public JsonResult status(int status, String message) {
        this.status = status;
        this.message = message;
        return this;
    }

    public String value() {
        return this.body;
    }

    public int status() {
        return this.status;
    }

    public String message() {
        return this.message;
    }
}

