/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.mapper;

import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jodd.bean.BeanUtil;
import jodd.db.JoddDb;
import jodd.db.oom.ColumnData;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.DbOomException;
import jodd.db.oom.DbOomQuery;
import jodd.db.oom.mapper.BaseResultSetMapper;
import jodd.db.type.SqlType;
import jodd.db.type.SqlTypeManager;
import jodd.typeconverter.TypeConverterManager;

public class DefaultResultSetMapper
extends BaseResultSetMapper {
    protected final DbOomQuery dbOomQuery;
    protected final boolean cacheEntities;
    protected final int totalColumns;
    protected final String[] columnNames;
    protected final int[] columnDbSqlTypes;
    protected final String[] tableNames;
    private final Set<String> resultColumns;
    protected DbEntityDescriptor[] cachedDbEntityDescriptors;
    protected Class[] cachedUsedTypes;
    protected String[] cachedTypesTableNames;
    protected String[][] cachedMappedNames;
    protected int cachedColumnNdx;
    protected Object cachedColumnValue;
    protected HashMap<Object, Object> entitiesCache;

    public DefaultResultSetMapper(ResultSet resultSet, Map<String, ColumnData> columnAliases, boolean cacheEntities, DbOomQuery dbOomQuery) {
        super(resultSet);
        this.dbOomQuery = dbOomQuery;
        this.cacheEntities = cacheEntities;
        try {
            ResultSetMetaData rsMetaData = resultSet.getMetaData();
            if (rsMetaData == null) {
                throw new DbOomException("No ResultSet meta-data");
            }
            this.totalColumns = rsMetaData.getColumnCount();
            this.resultColumns = new HashSet<String>(this.totalColumns);
            this.columnNames = new String[this.totalColumns];
            this.columnDbSqlTypes = new int[this.totalColumns];
            this.tableNames = new String[this.totalColumns];
            for (int i = 0; i < this.totalColumns; ++i) {
                ColumnData columnData;
                String columnName = rsMetaData.getColumnLabel(i + 1);
                if (columnName == null) {
                    columnName = rsMetaData.getColumnName(i + 1);
                }
                String tableName = null;
                String columnAliasSeparator = JoddDb.get().defaults().getDbOomConfig().getColumnAliasSeparator();
                int sepNdx = columnName.indexOf(columnAliasSeparator);
                if (sepNdx != -1) {
                    tableName = columnName.substring(0, sepNdx);
                    if (columnAliases != null && (columnData = columnAliases.get(tableName)) != null) {
                        tableName = columnData.getTableName();
                    }
                    columnName = columnName.substring(sepNdx + 1);
                } else {
                    if (columnAliases != null && (columnData = columnAliases.get(columnName)) != null) {
                        tableName = columnData.getTableName();
                        columnName = columnData.getColumnName();
                    }
                    if (tableName == null) {
                        try {
                            tableName = rsMetaData.getTableName(i + 1);
                        }
                        catch (SQLException sQLException) {
                            // empty catch block
                        }
                        if (tableName != null && tableName.length() == 0) {
                            tableName = null;
                        }
                    }
                }
                columnName = columnName.trim();
                if (columnName.length() == 0) {
                    columnName = null;
                }
                if (columnName != null) {
                    columnName = columnName.trim();
                    columnName = columnName.toUpperCase();
                }
                this.columnNames[i] = columnName;
                if (tableName != null) {
                    tableName = tableName.trim();
                    tableName = tableName.toUpperCase();
                }
                this.tableNames[i] = tableName;
                this.columnDbSqlTypes[i] = rsMetaData.getColumnType(i + 1);
            }
        }
        catch (SQLException sex) {
            throw new DbOomException(dbOomQuery, "Reading ResultSet meta-data failed", (Throwable)sex);
        }
    }

    @Override
    public Class[] resolveTables() {
        ArrayList classes = new ArrayList(this.tableNames.length);
        String lastTableName = null;
        this.resultColumns.clear();
        for (int i = 0; i < this.tableNames.length; ++i) {
            String tableName = this.tableNames[i];
            String columnName = this.columnNames[i];
            if (tableName == null) {
                throw new DbOomException(this.dbOomQuery, "Table name missing in meta-data");
            }
            if (!tableName.equals(lastTableName) || this.resultColumns.contains(columnName)) {
                this.resultColumns.clear();
                lastTableName = tableName;
                DbEntityDescriptor ded = DbEntityManager.get().lookupTableName(tableName);
                if (ded == null) {
                    throw new DbOomException(this.dbOomQuery, "Table name not registered: " + tableName);
                }
                classes.add(ded.getType());
            }
            this.resultColumns.add(columnName);
        }
        return classes.toArray(new Class[classes.size()]);
    }

    protected DbEntityDescriptor[] resolveDbEntityDescriptors(Class[] types) {
        if (this.cachedDbEntityDescriptors == null) {
            DbEntityDescriptor[] descs = new DbEntityDescriptor[types.length];
            for (int i = 0; i < types.length; ++i) {
                Class type = types[i];
                if (type == null) continue;
                descs[i] = DbEntityManager.get().lookupType(type);
            }
            this.cachedDbEntityDescriptors = descs;
        }
        return this.cachedDbEntityDescriptors;
    }

    protected String[] resolveTypesTableNames(Class[] types) {
        if (types != this.cachedUsedTypes) {
            this.cachedTypesTableNames = this.createTypesTableNames(types);
            this.cachedUsedTypes = types;
        }
        return this.cachedTypesTableNames;
    }

    protected String[][] resolveMappedTypesTableNames(Class[] types) {
        if (this.cachedMappedNames == null) {
            String[][] names = new String[types.length][];
            for (int i = 0; i < types.length; ++i) {
                Class[] mappedTypes;
                DbEntityDescriptor ded;
                Class type = types[i];
                if (type == null || (ded = this.cachedDbEntityDescriptors[i]) == null || (mappedTypes = ded.getMappedTypes()) == null) continue;
                names[i] = this.createTypesTableNames(mappedTypes);
            }
            this.cachedMappedNames = names;
        }
        return this.cachedMappedNames;
    }

    protected String[] createTypesTableNames(Class[] types) {
        String[] names = new String[types.length];
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null) {
                names[i] = null;
                continue;
            }
            DbEntityDescriptor ded = DbEntityManager.get().lookupType(types[i]);
            if (ded == null) continue;
            String tableName = ded.getTableName();
            names[i] = tableName = tableName.toUpperCase();
        }
        return names;
    }

    protected Object readColumnValue(int colNdx, Class destinationType, Class<? extends SqlType> sqlTypeClass, int columnDbSqlType) {
        if (colNdx != this.cachedColumnNdx) {
            try {
                SqlType sqlType = sqlTypeClass != null ? SqlTypeManager.lookupSqlType(sqlTypeClass) : SqlTypeManager.lookup(destinationType);
                if (sqlType != null) {
                    this.cachedColumnValue = sqlType.readValue(this.resultSet, colNdx + 1, destinationType, columnDbSqlType);
                } else {
                    this.cachedColumnValue = this.resultSet.getObject(colNdx + 1);
                    this.cachedColumnValue = TypeConverterManager.get().convertType(this.cachedColumnValue, destinationType);
                }
            }
            catch (SQLException sex) {
                throw new DbOomException(this.dbOomQuery, "Invalid value for column #" + (colNdx + 1), (Throwable)sex);
            }
            this.cachedColumnNdx = colNdx;
        }
        return this.cachedColumnValue;
    }

    @Override
    public Object[] parseObjects(Class ... types) {
        this.resultColumns.clear();
        int totalTypes = types.length;
        Object[] result = new Object[totalTypes];
        boolean[] resultUsage = new boolean[totalTypes];
        DbEntityDescriptor[] dbEntityDescriptors = this.resolveDbEntityDescriptors(types);
        String[] typesTableNames = this.resolveTypesTableNames(types);
        String[][] mappedNames = this.resolveMappedTypesTableNames(types);
        int currentResult = 0;
        this.cachedColumnNdx = -1;
        int colNdx = 0;
        while (colNdx < this.totalColumns && currentResult < totalTypes) {
            Class currentType = types[currentResult];
            if (currentType == null) {
                ++colNdx;
                ++currentResult;
                this.resultColumns.clear();
                continue;
            }
            String columnName = this.columnNames[colNdx];
            int columnDbSqlType = this.columnDbSqlTypes[colNdx];
            String tableName = this.tableNames[colNdx];
            String resultTableName = typesTableNames[currentResult];
            if (resultTableName == null) {
                result[currentResult] = this.readColumnValue(colNdx, currentType, null, columnDbSqlType);
                resultUsage[currentResult] = true;
                ++colNdx;
                ++currentResult;
                this.resultColumns.clear();
                continue;
            }
            boolean tableMatched = false;
            if (tableName == null) {
                tableMatched = true;
            } else if (resultTableName.equals(tableName)) {
                tableMatched = true;
            } else {
                String[] mapped = mappedNames[currentResult];
                if (mapped != null) {
                    for (String m : mapped) {
                        if (!m.equals(tableName)) continue;
                        tableMatched = true;
                        break;
                    }
                }
            }
            if (tableMatched && !this.resultColumns.contains(columnName)) {
                String propertyName;
                DbEntityDescriptor ded = dbEntityDescriptors[currentResult];
                DbEntityColumnDescriptor dec = ded.findByColumnName(columnName);
                String string = propertyName = dec == null ? null : dec.getPropertyName();
                if (propertyName != null) {
                    Class<?> type;
                    if (result[currentResult] == null) {
                        result[currentResult] = DbEntityManager.get().createEntityInstance(currentType);
                    }
                    if ((type = BeanUtil.declared.getPropertyType(result[currentResult], propertyName)) != null) {
                        dec.updateDbSqlType(columnDbSqlType);
                        Class<? extends SqlType> sqlTypeClass = dec.getSqlTypeClass();
                        Object value = this.readColumnValue(colNdx, type, sqlTypeClass, columnDbSqlType);
                        if (value != null) {
                            BeanUtil.declared.setProperty(result[currentResult], propertyName, value);
                            resultUsage[currentResult] = true;
                        }
                        ++colNdx;
                        this.resultColumns.add(columnName);
                        continue;
                    }
                }
            }
            ++currentResult;
            this.resultColumns.clear();
        }
        this.resultColumns.clear();
        for (int i = 0; i < resultUsage.length; ++i) {
            if (resultUsage[i]) continue;
            result[i] = null;
        }
        if (this.cacheEntities) {
            this.cacheResultSetEntities(result);
        }
        return result;
    }

    protected void cacheResultSetEntities(Object[] result) {
        if (this.entitiesCache == null) {
            this.entitiesCache = new HashMap();
        }
        for (int i = 0; i < result.length; ++i) {
            DbEntityDescriptor ded;
            Object object = result[i];
            if (object == null || (ded = this.cachedDbEntityDescriptors[i]) == null) continue;
            Object key = ded.hasIdColumn() ? ded.getKeyValue(object) : object;
            Object cachedObject = this.entitiesCache.get(key);
            if (cachedObject == null) {
                this.entitiesCache.put(key, object);
                continue;
            }
            result[i] = cachedObject;
        }
    }
}

