/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen;

import jodd.bean.BeanUtil;
import jodd.db.JoddDb;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbEntityManager;
import jodd.db.oom.sqlgen.DbSqlBuilder;
import jodd.util.StringUtil;

public class DbEntitySql {
    private static final String DELETE_FROM = "delete from ";
    private static final String WHERE = " where ";
    private static final String UPDATE = "update ";
    private static final String SELECT = "select ";
    private static final String FROM = " from ";
    private static final String SET = " set ";
    private static final String SELECT_COUNT_1_FROM = "select count(*) from ";

    public static DbSqlBuilder insert(Object entity) {
        return DbSqlBuilder.sql().insert(entity);
    }

    public static DbSqlBuilder truncate(Object entity) {
        return DbSqlBuilder.sql().$(DELETE_FROM).table(entity, null);
    }

    public static DbSqlBuilder update(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        if (!JoddDb.get().defaults().getSqlGenConfig().isUpdateAcceptsTableAlias()) {
            tableRef = null;
        }
        return DbSqlBuilder.sql().$(UPDATE).table(entity, tableRef).set(tableRef, entity).$(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        if (!JoddDb.get().defaults().getSqlGenConfig().isUpdateAcceptsTableAlias()) {
            tableRef = null;
        }
        return DbSqlBuilder.sql().$(UPDATE).table(entity, tableRef).setAll(tableRef, entity).$(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateColumn(Object entity, String columnRef, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        if (!JoddDb.get().defaults().getSqlGenConfig().isUpdateAcceptsTableAlias()) {
            tableRef = null;
        }
        return DbSqlBuilder.sql().$(UPDATE).table(entity, tableRef).$(SET).ref(null, columnRef).$("=").columnValue(value).$(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder updateColumn(Object entity, String columnRef) {
        Object value = BeanUtil.pojo.getProperty(entity, columnRef);
        return DbEntitySql.updateColumn(entity, columnRef, value);
    }

    public static DbSqlBuilder delete(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(DELETE_FROM).table(entity, null, tableRef).$(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder deleteByAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(DELETE_FROM).table(entity, null, tableRef).$(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder deleteById(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(DELETE_FROM).table(entity, null, tableRef).$(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder deleteById(Object entityType, long id) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql().$(DELETE_FROM).table(entityType, null, tableRef).$(WHERE).refId(tableRef).$("=").columnValue(id);
    }

    public static DbSqlBuilder from(Object entity) {
        return DbEntitySql.from(entity, DbEntitySql.createTableRefName(entity));
    }

    public static DbSqlBuilder from(Object entity, String tableRef) {
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entity, tableRef).$(" ");
    }

    public static DbSqlBuilder from(Class entityType) {
        return DbEntitySql.from(entityType, DbEntitySql.createTableRefName(entityType));
    }

    public static DbSqlBuilder from(Class entityType, String tableRef) {
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entityType, tableRef).$(" ");
    }

    public static DbSqlBuilder find(Class target, Object matchEntity) {
        String tableRef = DbEntitySql.createTableRefName(target);
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(target, tableRef).$(WHERE).match(tableRef, matchEntity);
    }

    public static DbSqlBuilder find(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entity, tableRef).$(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder findByAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entity, tableRef).$(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder findByColumn(Class entity, String column, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entity, tableRef).$(WHERE).ref(tableRef, column).$("=").columnValue(value);
    }

    public static DbSqlBuilder findForeign(Class entity, Object value) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        DbEntityDescriptor<?> dedFk = DbEntityManager.get().lookupType(value.getClass());
        String tableName = JoddDb.get().defaults().getDbOomConfig().getTableNames().convertTableNameToEntityName(dedFk.getTableName());
        String columnName = JoddDb.get().defaults().getDbOomConfig().getColumnNames().convertColumnNameToPropertyName(dedFk.getIdColumnName());
        String fkColumn = StringUtil.uncapitalize(tableName) + StringUtil.capitalize(columnName);
        Object idValue = BeanUtil.pojo.getProperty(value, dedFk.getIdPropertyName());
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entity, tableRef).$(WHERE).ref(tableRef, fkColumn).$("=").columnValue(idValue);
    }

    public static DbSqlBuilder findById(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entity, tableRef).$(WHERE).matchIds(tableRef, entity);
    }

    public static DbSqlBuilder findById(Object entityType, long id) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql().$(SELECT).column(tableRef).$(FROM).table(entityType, tableRef).$(WHERE).refId(tableRef).$("=").columnValue(id);
    }

    public static DbSqlBuilder count(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(SELECT_COUNT_1_FROM).table(entity, tableRef).$(WHERE).match(tableRef, entity);
    }

    public static DbSqlBuilder count(Class entityType) {
        String tableRef = DbEntitySql.createTableRefName(entityType);
        return DbSqlBuilder.sql().$(SELECT_COUNT_1_FROM).table(entityType, tableRef);
    }

    public static DbSqlBuilder countAll(Object entity) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(SELECT_COUNT_1_FROM).table(entity, tableRef).$(WHERE).matchAll(tableRef, entity);
    }

    public static DbSqlBuilder increaseColumn(Class entity, long id, String columnRef, Number delta, boolean increase) {
        String tableRef = DbEntitySql.createTableRefName(entity);
        return DbSqlBuilder.sql().$(UPDATE).table(entity, null, tableRef).$(SET).ref(null, columnRef).$("=").ref(null, columnRef).$(increase ? "+" : "-").columnValue(delta).$(WHERE).refId(tableRef).$("=").columnValue(id);
    }

    protected static String createTableRefName(Object entity) {
        Class type = entity.getClass();
        type = type == Class.class ? (Class)entity : type;
        return type.getSimpleName() + '_';
    }
}

