/*
 * Decompiled with CFR 0.152.
 */
package jodd.madvoc.component;

import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.madvoc.MadvocConfig;
import jodd.madvoc.MadvocUtil;
import jodd.madvoc.component.ActionsManager;
import jodd.madvoc.config.ActionRuntime;
import jodd.madvoc.config.ResultPath;
import jodd.petite.meta.PetiteInject;
import jodd.util.StringUtil;

public class ResultMapper {
    private static final Logger log = LoggerFactory.getLogger(ResultMapper.class);
    @PetiteInject
    protected ActionsManager actionsManager;
    @PetiteInject
    protected MadvocConfig madvocConfig;

    protected String lookupAlias(String alias) {
        ActionRuntime cfg;
        String value = this.actionsManager.lookupPathAlias(alias);
        if (value == null && (cfg = this.actionsManager.lookup(alias)) != null) {
            value = cfg.getActionPath();
        }
        return value;
    }

    protected String resolveAlias(String value) {
        StringBuilder result = new StringBuilder(value.length());
        int i = 0;
        int len = value.length();
        while (i < len) {
            int ndx = value.indexOf(60, i);
            if (ndx == -1) {
                if (i == 0) {
                    String alias = this.lookupAlias(value);
                    return alias != null ? alias : value;
                }
                result.append(value.substring(i));
                break;
            }
            result.append(value.substring(i, ndx));
            int ndx2 = value.indexOf(62, ++ndx);
            String aliasName = ndx2 == -1 ? value.substring(ndx) : value.substring(ndx, ndx2);
            String alias = this.lookupAlias(aliasName);
            if (alias != null) {
                result.append(alias);
            } else if (log.isWarnEnabled()) {
                log.warn("Alias not found: " + aliasName);
            }
            i = ndx2 + 1;
        }
        len = result.length();
        for (i = 0; i < len && result.charAt(i) == '/'; ++i) {
        }
        if (i > 1) {
            return result.substring(i - 1, len);
        }
        return result.toString();
    }

    public ResultPath resolveResultPath(String path, String value) {
        String resultPathPrefix;
        boolean absolutePath = false;
        if (value != null) {
            if (StringUtil.startsWithChar(value = this.resolveAlias(value), '/')) {
                absolutePath = true;
                int dotNdx = value.indexOf("..");
                if (dotNdx != -1) {
                    path = value.substring(0, dotNdx);
                    value = value.substring(dotNdx + 2);
                } else {
                    path = value;
                    value = null;
                }
            } else {
                int dotNdx;
                int i;
                for (i = 0; i < value.length() && value.charAt(i) == '#'; ++i) {
                    dotNdx = MadvocUtil.lastIndexOfSlashDot(path);
                    if (dotNdx == -1) continue;
                    path = path.substring(0, dotNdx);
                }
                if (i > 0) {
                    if (StringUtil.startsWithChar(value = value.substring(i), '.')) {
                        value = value.substring(1);
                    } else {
                        dotNdx = value.indexOf("..");
                        if (dotNdx != -1) {
                            path = path + '.' + value.substring(0, dotNdx);
                            value = value.substring(dotNdx + 2);
                        } else {
                            if (value.length() > 0) {
                                path = StringUtil.endsWithChar(path, '/') ? path + value : path + '.' + value;
                            }
                            value = null;
                        }
                    }
                }
            }
        }
        if (!absolutePath && (resultPathPrefix = this.madvocConfig.getResultPathPrefix()) != null) {
            path = resultPathPrefix + path;
        }
        return new ResultPath(path, value);
    }

    public String resolveResultPathString(String path, String value) {
        ResultPath resultPath = this.resolveResultPath(path, value);
        String result = resultPath.pathValue();
        return this.resolveAlias(result);
    }
}

