/*
 * Decompiled with CFR 0.152.
 */
package jodd.petite;

import java.util.Collection;
import jodd.bean.BeanUtil;
import jodd.log.Logger;
import jodd.log.LoggerFactory;
import jodd.petite.BeanDefinition;
import jodd.petite.PetiteBeans;
import jodd.petite.PetiteConfig;
import jodd.petite.PetiteException;
import jodd.petite.PetiteRegistry;
import jodd.petite.ScopedProxyManager;
import jodd.petite.WiringMode;
import jodd.petite.def.BeanReferences;
import jodd.petite.def.InitMethodPoint;
import jodd.petite.def.MethodInjectionPoint;
import jodd.petite.def.PropertyInjectionPoint;
import jodd.petite.def.ProviderDefinition;
import jodd.petite.def.SetInjectionPoint;
import jodd.petite.meta.InitMethodInvocationStrategy;
import jodd.petite.scope.Scope;
import jodd.petite.scope.SingletonScope;

public class PetiteContainer
extends PetiteBeans {
    private static final Logger log = LoggerFactory.getLogger(PetiteContainer.class);
    public static final String PETITE_CONTAINER_REF_NAME = "petiteContainer";
    protected final ScopedProxyManager scopedProxyManager = new ScopedProxyManager();

    public PetiteContainer() {
        this(new PetiteConfig());
    }

    public PetiteContainer(PetiteConfig config) {
        super(config);
        if (log.isDebugEnabled()) {
            log.debug("Petite container created");
        }
    }

    protected Object newBeanInstance(BeanDefinition def) {
        Object bean;
        if (def.ctor == null) {
            def.ctor = this.petiteResolvers.resolveCtorInjectionPoint(def.type);
        }
        int paramNo = def.ctor.references.length;
        Object[] args = new Object[paramNo];
        if (def.wiringMode != WiringMode.NONE) {
            for (int i = 0; i < paramNo; ++i) {
                args[i] = this.getBean(def.ctor.references[i]);
                if (args[i] != null || def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring constructor failed. References '" + def.ctor.references[i] + "' not found for constructor: " + def.ctor.constructor);
            }
        }
        try {
            bean = def.ctor.constructor.newInstance(args);
        }
        catch (Exception ex) {
            throw new PetiteException("Failed to create new bean instance '" + def.type.getName() + "' using constructor: " + def.ctor.constructor, ex);
        }
        return bean;
    }

    protected void wireBean(Object bean, BeanDefinition def) {
        if (def.wiringMode == WiringMode.NONE) {
            return;
        }
        this.wireProperties(bean, def);
        this.wireMethods(bean, def);
    }

    protected void wireProperties(Object bean, BeanDefinition def) {
        Object setter;
        if (def.properties == null) {
            def.properties = this.petiteResolvers.resolvePropertyInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        boolean mixing = this.petiteConfig.wireScopedProxy || this.petiteConfig.detectMixedScopes;
        for (PropertyInjectionPoint pip : def.properties) {
            BeanDefinition refBeanDefinition;
            BeanReferences refNames = pip.references;
            Object value = null;
            if (mixing && (refBeanDefinition = this.lookupBeanDefinitions(refNames)) != null) {
                value = this.scopedProxyManager.lookupValue(this, def, refBeanDefinition);
            }
            if (value == null) {
                value = this.getBean(refNames);
            }
            if (value == null) {
                if (def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring failed. Beans references: '" + refNames + "' not found for property: " + def.type.getName() + '#' + pip.propertyDescriptor.getName());
            }
            setter = pip.propertyDescriptor.getSetter(true);
            try {
                setter.invokeSetter(bean, value);
            }
            catch (Exception ex) {
                throw new PetiteException("Wiring failed", ex);
            }
        }
        if (def.sets == null) {
            def.sets = this.petiteResolvers.resolveSetInjectionPoint(def.type, def.wiringMode == WiringMode.AUTOWIRE);
        }
        for (SetInjectionPoint sip : def.sets) {
            String[] beanNames = this.resolveBeanNamesForType(sip.targetClass);
            Collection beans = sip.createSet(beanNames.length);
            for (String beanName : beanNames) {
                if (beanName.equals(def.name)) continue;
                Object value = this.getBean(beanName);
                beans.add(value);
            }
            setter = sip.propertyDescriptor.getSetter(true);
            try {
                setter.invokeSetter(bean, beans);
            }
            catch (Exception ex) {
                throw new PetiteException("Wiring failed", ex);
            }
        }
    }

    protected void wireMethods(Object bean, BeanDefinition def) {
        if (def.methods == null) {
            def.methods = this.petiteResolvers.resolveMethodInjectionPoint(def.type);
        }
        for (MethodInjectionPoint methodRef : def.methods) {
            BeanReferences[] refNames = methodRef.references;
            Object[] args = new Object[refNames.length];
            for (int i = 0; i < refNames.length; ++i) {
                BeanDefinition refBeanDefinition;
                boolean mixing;
                BeanReferences refName = refNames[i];
                Object value = null;
                boolean bl = mixing = this.petiteConfig.wireScopedProxy || this.petiteConfig.detectMixedScopes;
                if (mixing && (refBeanDefinition = this.lookupBeanDefinitions(refName)) != null) {
                    value = this.scopedProxyManager.lookupValue(this, def, refBeanDefinition);
                }
                if (value == null) {
                    value = this.getBean(refName);
                }
                args[i] = value;
                if (value != null || def.wiringMode != WiringMode.STRICT) continue;
                throw new PetiteException("Wiring failed. Beans references: '" + refName + "' not found for method: " + def.type.getName() + '#' + methodRef.method.getName());
            }
            try {
                methodRef.method.invoke(bean, args);
            }
            catch (Exception ex) {
                throw new PetiteException(ex);
            }
        }
    }

    protected void resolveInitAndDestroyMethods(Object bean, BeanDefinition def) {
        if (def.initMethods == null) {
            def.initMethods = this.petiteResolvers.resolveInitMethodPoint(bean);
        }
        if (def.destroyMethods == null) {
            def.destroyMethods = this.petiteResolvers.resolveDestroyMethodPoint(bean);
        }
    }

    protected void invokeInitMethods(Object bean, BeanDefinition def, InitMethodInvocationStrategy invocationStrategy) {
        for (InitMethodPoint initMethod : def.initMethods) {
            if (invocationStrategy != initMethod.invocationStrategy) continue;
            try {
                initMethod.method.invoke(bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid init method: " + initMethod, ex);
            }
        }
    }

    protected void injectParams(Object bean, BeanDefinition def) {
        if (def.name == null) {
            return;
        }
        if (def.params == null) {
            def.params = this.resolveBeanParams(def.name, this.petiteConfig.getResolveReferenceParameters());
        }
        int len = def.name.length() + 1;
        for (String param : def.params) {
            Object value = this.getParameter(param);
            String destination = param.substring(len);
            try {
                BeanUtil.declared.setProperty(bean, destination, value);
            }
            catch (Exception ex) {
                throw new PetiteException("Unable to set parameter: '" + param + "' to bean: " + def.name, ex);
            }
        }
    }

    protected <T> void invokeConsumerIfRegistered(T bean, BeanDefinition<T> def) {
        if (def.consumer() == null) {
            return;
        }
        def.consumer().accept(bean);
    }

    public <T> T getBean(Class<T> type) {
        String name = this.resolveBeanName(type);
        return this.getBean(name);
    }

    protected Object getBean(BeanReferences beanReferences) {
        int total = beanReferences.size();
        for (int i = 0; i < total; ++i) {
            Object bean;
            String name = beanReferences.name(i);
            if (name == null || (bean = this.getBean(name)) == null) continue;
            return bean;
        }
        return null;
    }

    public <T> T getBean(String name) {
        BeanDefinition def = this.lookupBeanDefinition(name);
        if (def == null) {
            ProviderDefinition providerDefinition = (ProviderDefinition)this.providers.get(name);
            if (providerDefinition != null) {
                return (T)this.invokeProvider(providerDefinition);
            }
            return null;
        }
        Object bean = def.scopeLookup();
        if (bean == null) {
            bean = this.newBeanInstance(def);
            this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(def, bean);
        }
        return (T)bean;
    }

    protected void registerBeanAndWireAndInjectParamsAndInvokeInitMethods(BeanDefinition def, Object bean) {
        this.resolveInitAndDestroyMethods(bean, def);
        def.scopeRegister(bean);
        this.invokeInitMethods(bean, def, InitMethodInvocationStrategy.POST_CONSTRUCT);
        this.wireBean(bean, def);
        this.invokeInitMethods(bean, def, InitMethodInvocationStrategy.POST_DEFINE);
        this.injectParams(bean, def);
        this.invokeInitMethods(bean, def, InitMethodInvocationStrategy.POST_INITIALIZE);
        this.invokeConsumerIfRegistered(bean, def);
    }

    public void wire(Object bean) {
        this.wire(bean, null);
    }

    public void wire(Object bean, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition def = new BeanDefinition(null, bean.getClass(), null, wiringMode, null);
        this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(def, bean);
    }

    public <E> E createBean(Class<E> type) {
        return this.createBean(type, null);
    }

    public <E> E createBean(Class<E> type, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        BeanDefinition<E> def = new BeanDefinition<E>(null, type, null, wiringMode, null);
        Object bean = this.newBeanInstance(def);
        this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(def, bean);
        return (E)bean;
    }

    protected Object invokeProvider(ProviderDefinition provider) {
        if (provider.method != null) {
            Object bean = provider.beanName != null ? this.getBean(provider.beanName) : null;
            try {
                return provider.method.invoke(bean, new Object[0]);
            }
            catch (Exception ex) {
                throw new PetiteException("Invalid provider method: " + provider.method.getName(), ex);
            }
        }
        throw new PetiteException("Invalid provider");
    }

    public void addBean(String name, Object bean) {
        this.addBean(name, bean, null);
    }

    public void addBean(String name, Object bean, WiringMode wiringMode) {
        wiringMode = this.petiteConfig.resolveWiringMode(wiringMode);
        this.registerPetiteBean(bean.getClass(), name, SingletonScope.class, wiringMode, false, null);
        BeanDefinition def = this.lookupExistingBeanDefinition(name);
        this.registerBeanAndWireAndInjectParamsAndInvokeInitMethods(def, bean);
    }

    public void addSelf(String name) {
        this.addBean(name, this, WiringMode.NONE);
    }

    public void addSelf() {
        this.addBean(PETITE_CONTAINER_REF_NAME, this, WiringMode.NONE);
    }

    public void setBeanProperty(String name, Object value) {
        String beanName;
        Object bean = null;
        int ndx = name.length();
        while ((ndx = name.lastIndexOf(46, ndx)) != -1 && (bean = this.getBean(beanName = name.substring(0, ndx))) == null) {
            --ndx;
        }
        if (bean == null) {
            throw new PetiteException("Invalid bean property: " + name);
        }
        try {
            BeanUtil.declared.setProperty(bean, name.substring(ndx + 1), value);
        }
        catch (Exception ex) {
            throw new PetiteException("Invalid bean property: " + name, ex);
        }
    }

    public Object getBeanProperty(String name) {
        int ndx = name.indexOf(46);
        if (ndx == -1) {
            throw new PetiteException("Only bean name is specified, missing property name: " + name);
        }
        String beanName = name.substring(0, ndx);
        Object bean = this.getBean(beanName);
        if (bean == null) {
            throw new PetiteException("Bean doesn't exist: " + name);
        }
        try {
            return BeanUtil.declared.getProperty(bean, name.substring(ndx + 1));
        }
        catch (Exception ex) {
            throw new PetiteException("Invalid bean property: " + name, ex);
        }
    }

    public PetiteRegistry createContainerRegistry() {
        return PetiteRegistry.of(this);
    }

    public void shutdown() {
        for (Scope scope : this.scopes.values()) {
            scope.shutdown();
        }
        this.beans.clear();
        this.beansAlt.clear();
        this.scopes.clear();
        this.providers.clear();
        this.beanCollections.clear();
    }
}

