/*
 * Decompiled with CFR 0.152.
 */
package jodd.upload;

import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import jodd.io.FastByteArrayOutputStream;
import jodd.upload.FileUpload;
import jodd.upload.FileUploadFactory;
import jodd.upload.FileUploadHeader;
import jodd.upload.MultipartRequestInputStream;
import jodd.upload.impl.MemoryFileUploadFactory;
import jodd.util.ArraysUtil;

public class MultipartStreamParser {
    protected FileUploadFactory fileUploadFactory;
    protected Map<String, String[]> requestParameters;
    protected Map<String, FileUpload[]> requestFiles;
    private boolean parsed;

    public MultipartStreamParser() {
        this(null);
    }

    public MultipartStreamParser(FileUploadFactory fileUploadFactory) {
        this.fileUploadFactory = fileUploadFactory == null ? new MemoryFileUploadFactory() : fileUploadFactory;
    }

    protected void setParsed() throws IOException {
        if (this.parsed) {
            throw new IOException("Multi-part request already parsed");
        }
        this.parsed = true;
    }

    public boolean isParsed() {
        return this.parsed;
    }

    protected void putFile(String name, FileUpload value) {
        FileUpload[] fileUploads;
        if (this.requestFiles == null) {
            this.requestFiles = new HashMap<String, FileUpload[]>();
        }
        fileUploads = (fileUploads = this.requestFiles.get(name)) != null ? ArraysUtil.append(fileUploads, value) : new FileUpload[]{value};
        this.requestFiles.put(name, fileUploads);
    }

    protected void putParameters(String name, String[] values) {
        if (this.requestParameters == null) {
            this.requestParameters = new HashMap<String, String[]>();
        }
        this.requestParameters.put(name, values);
    }

    protected void putParameter(String name, String value) {
        String[] params;
        if (this.requestParameters == null) {
            this.requestParameters = new HashMap<String, String[]>();
        }
        params = (params = this.requestParameters.get(name)) != null ? ArraysUtil.append(params, value) : new String[]{value};
        this.requestParameters.put(name, params);
    }

    public void parseRequestStream(InputStream inputStream, String encoding) throws IOException {
        FileUploadHeader header;
        this.setParsed();
        MultipartRequestInputStream input = new MultipartRequestInputStream(inputStream);
        input.readBoundary();
        while ((header = input.readDataHeader(encoding)) != null) {
            if (header.isFile) {
                String fileName = header.fileName;
                if (fileName.length() > 0 && header.contentType.indexOf("application/x-macbinary") > 0) {
                    input.skipBytes(128);
                }
                FileUpload newFile = this.fileUploadFactory.create(input);
                newFile.processStream();
                if (fileName.length() == 0 && newFile.getSize() == 0) {
                    newFile.size = -1;
                }
                this.putFile(header.formFieldName, newFile);
            } else {
                FastByteArrayOutputStream fbos = new FastByteArrayOutputStream();
                input.copyAll(fbos);
                String value = encoding != null ? new String(fbos.toByteArray(), encoding) : new String(fbos.toByteArray());
                this.putParameter(header.formFieldName, value);
            }
            input.skipBytes(1);
            input.mark(1);
            int nextByte = input.read();
            if (nextByte == -1 || nextByte == 45) {
                input.reset();
                break;
            }
            input.reset();
        }
    }

    public String getParameter(String paramName) {
        if (this.requestParameters == null) {
            return null;
        }
        String[] values = this.requestParameters.get(paramName);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public Set<String> getParameterNames() {
        if (this.requestParameters == null) {
            return Collections.emptySet();
        }
        return this.requestParameters.keySet();
    }

    public String[] getParameterValues(String paramName) {
        if (this.requestParameters == null) {
            return null;
        }
        return this.requestParameters.get(paramName);
    }

    public FileUpload getFile(String paramName) {
        if (this.requestFiles == null) {
            return null;
        }
        FileUpload[] values = this.requestFiles.get(paramName);
        if (values != null && values.length > 0) {
            return values[0];
        }
        return null;
    }

    public FileUpload[] getFiles(String paramName) {
        if (this.requestFiles == null) {
            return null;
        }
        return this.requestFiles.get(paramName);
    }

    public Set<String> getFileParameterNames() {
        if (this.requestFiles == null) {
            return Collections.emptySet();
        }
        return this.requestFiles.keySet();
    }
}

