/*
 * Decompiled with CFR 0.152.
 */
package jodd.db.oom.sqlgen.chunks;

import jodd.bean.BeanUtil;
import jodd.db.JoddDb;
import jodd.db.oom.DbEntityColumnDescriptor;
import jodd.db.oom.DbEntityDescriptor;
import jodd.db.oom.DbOomUtil;
import jodd.db.oom.sqlgen.chunks.SqlChunk;
import jodd.util.StringUtil;

public class UpdateSetChunk
extends SqlChunk {
    private static final String SET = "set ";
    protected final Object data;
    protected final String tableRef;
    protected final int includeColumns;

    public UpdateSetChunk(String tableRef, Object data, int includeColumns) {
        super(6);
        this.tableRef = tableRef;
        this.data = data;
        this.includeColumns = includeColumns;
    }

    @Override
    public void process(StringBuilder out) {
        if (this.isPreviousChunkOfType(2)) {
            this.appendMissingSpace(out);
        }
        DbEntityDescriptor ded = this.tableRef != null ? this.lookupTableRef(this.tableRef) : this.lookupType(UpdateSetChunk.resolveClass(this.data));
        out.append(SET);
        DbEntityColumnDescriptor[] decList = ded.getColumnDescriptors();
        String typeName = StringUtil.uncapitalize(ded.getEntityName());
        int size = 0;
        for (DbEntityColumnDescriptor dec : decList) {
            boolean isUpdateablePrimaryKey = JoddDb.get().defaults().getSqlGenConfig().isUpdateablePrimaryKey();
            if (dec.isId() && !isUpdateablePrimaryKey) continue;
            String property = dec.getPropertyName();
            Object value = BeanUtil.declared.getProperty(this.data, property);
            if (this.includeColumns == 1 && DbOomUtil.isEmptyColumnValue(dec, value)) continue;
            if (size > 0) {
                out.append(',').append(' ');
            }
            ++size;
            out.append(dec.getColumnName()).append('=');
            String propertyName = typeName + '.' + property;
            this.defineParameter(out, propertyName, value, dec);
        }
        if (size > 0) {
            out.append(' ');
        }
    }
}

