/*
 * Decompiled with CFR 0.152.
 */
package jodd.json;

import java.io.File;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.Map;
import jodd.datetime.JDateTime;
import jodd.introspector.ClassDescriptor;
import jodd.introspector.ClassIntrospector;
import jodd.json.JoddJson;
import jodd.json.JsonArray;
import jodd.json.JsonObject;
import jodd.json.TypeJsonSerializer;
import jodd.json.impl.ArraysJsonSerializer;
import jodd.json.impl.BooleanArrayJsonSerializer;
import jodd.json.impl.BooleanJsonSerializer;
import jodd.json.impl.ByteArrayJsonSerializer;
import jodd.json.impl.CalendarJsonSerializer;
import jodd.json.impl.CharSequenceJsonSerializer;
import jodd.json.impl.CharacterJsonSerializer;
import jodd.json.impl.ClassJsonSerializer;
import jodd.json.impl.DateJsonSerializer;
import jodd.json.impl.DoubleArrayJsonSerializer;
import jodd.json.impl.DoubleJsonSerializer;
import jodd.json.impl.EnumJsonSerializer;
import jodd.json.impl.FileJsonSerializer;
import jodd.json.impl.FloatArrayJsonSerializer;
import jodd.json.impl.FloatJsonSerializer;
import jodd.json.impl.IntArrayJsonSerializer;
import jodd.json.impl.IterableJsonSerializer;
import jodd.json.impl.JDateTimeSerializer;
import jodd.json.impl.JsonArraySerializer;
import jodd.json.impl.JsonObjectSerializer;
import jodd.json.impl.LongArrayJsonSerializer;
import jodd.json.impl.MapJsonSerializer;
import jodd.json.impl.NumberJsonSerializer;
import jodd.json.impl.ObjectJsonSerializer;
import jodd.util.collection.ClassMap;

public class TypeJsonSerializerMap {
    private final TypeJsonSerializerMap defaultSerializerMap;
    protected final ClassMap<TypeJsonSerializer> map = new ClassMap();
    protected final ClassMap<TypeJsonSerializer> cache = new ClassMap();

    public static TypeJsonSerializerMap get() {
        return JoddJson.get().typeSerializers();
    }

    public TypeJsonSerializerMap() {
        this.registerDefaults();
        this.defaultSerializerMap = null;
    }

    public TypeJsonSerializerMap(TypeJsonSerializerMap defaultSerializerMap) {
        this.defaultSerializerMap = defaultSerializerMap;
    }

    public void registerDefaults() {
        this.map.put(Object.class, new ObjectJsonSerializer());
        this.map.put(Map.class, new MapJsonSerializer());
        this.map.put(Iterable.class, new IterableJsonSerializer());
        this.map.put(JsonObject.class, new JsonObjectSerializer());
        this.map.put(JsonArray.class, new JsonArraySerializer());
        this.map.put(int[].class, new IntArrayJsonSerializer());
        this.map.put(long[].class, new LongArrayJsonSerializer());
        this.map.put(double[].class, new DoubleArrayJsonSerializer());
        this.map.put(float[].class, new FloatArrayJsonSerializer());
        this.map.put(boolean[].class, new BooleanArrayJsonSerializer());
        this.map.put(byte[].class, new ByteArrayJsonSerializer());
        this.map.put(Integer[].class, new ArraysJsonSerializer<Integer>(){

            protected int getLength(Integer[] array) {
                return array.length;
            }

            protected Integer get(Integer[] array, int index) {
                return array[index];
            }
        });
        this.map.put(Long[].class, new ArraysJsonSerializer<Long>(){

            protected int getLength(Long[] array) {
                return array.length;
            }

            protected Long get(Long[] array, int index) {
                return array[index];
            }
        });
        this.map.put(Arrays.class, new ArraysJsonSerializer());
        TypeJsonSerializer<CharSequence> jsonSerializer = new CharSequenceJsonSerializer();
        this.map.put(String.class, jsonSerializer);
        this.map.put(StringBuilder.class, jsonSerializer);
        this.map.put(CharSequence.class, jsonSerializer);
        jsonSerializer = new NumberJsonSerializer();
        this.map.put(Number.class, jsonSerializer);
        this.map.put(Integer.class, jsonSerializer);
        this.map.put(Integer.TYPE, jsonSerializer);
        this.map.put(Long.class, jsonSerializer);
        this.map.put(Long.TYPE, jsonSerializer);
        DoubleJsonSerializer doubleJsonSerializer = new DoubleJsonSerializer();
        this.map.put(Double.class, doubleJsonSerializer);
        this.map.put(Double.TYPE, doubleJsonSerializer);
        FloatJsonSerializer floatJsonSerializer = new FloatJsonSerializer();
        this.map.put(Float.class, floatJsonSerializer);
        this.map.put(Float.TYPE, floatJsonSerializer);
        this.map.put(BigInteger.class, jsonSerializer);
        this.map.put(BigDecimal.class, jsonSerializer);
        this.map.put(Boolean.class, new BooleanJsonSerializer());
        this.map.put(Boolean.TYPE, new BooleanJsonSerializer());
        this.map.put(Date.class, new DateJsonSerializer());
        this.map.put(Calendar.class, new CalendarJsonSerializer());
        this.map.put(JDateTime.class, new JDateTimeSerializer());
        this.map.put(Enum.class, new EnumJsonSerializer());
        this.map.put(File.class, new FileJsonSerializer(FileJsonSerializer.Type.PATH));
        jsonSerializer = new CharacterJsonSerializer();
        this.map.put(Character.class, jsonSerializer);
        this.map.put(Character.TYPE, jsonSerializer);
        this.map.put(Class.class, new ClassJsonSerializer());
        this.cache.clear();
    }

    public void register(Class type, TypeJsonSerializer typeJsonSerializer) {
        this.map.put(type, typeJsonSerializer);
        this.cache.clear();
    }

    public TypeJsonSerializer lookup(Class type) {
        TypeJsonSerializer tjs = this.cache.unsafeGet(type);
        if (tjs != null) {
            return tjs;
        }
        tjs = this._lookup(type);
        this.cache.put(type, tjs);
        return tjs;
    }

    protected TypeJsonSerializer lookupSerializer(Class type) {
        TypeJsonSerializer tjs = this.map.unsafeGet(type);
        if (tjs == null && this.defaultSerializerMap != null) {
            tjs = this.defaultSerializerMap.map.unsafeGet(type);
        }
        return tjs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected TypeJsonSerializer _lookup(Class type) {
        ClassMap<TypeJsonSerializer> classMap = this.map;
        synchronized (classMap) {
            Class[] superclasses;
            Class[] interfaces;
            TypeJsonSerializer tjs = this.lookupSerializer(type);
            if (tjs != null) {
                return tjs;
            }
            ClassDescriptor cd = ClassIntrospector.get().lookup(type);
            if (cd.isArray()) {
                return this.lookupSerializer(Arrays.class);
            }
            for (Class interfaze : interfaces = cd.getAllInterfaces()) {
                tjs = this.lookupSerializer(interfaze);
                if (tjs == null) continue;
                return tjs;
            }
            for (Class clazz : superclasses = cd.getAllSuperclasses()) {
                tjs = this.lookupSerializer(clazz);
                if (tjs == null) continue;
                return tjs;
            }
            return this.lookupSerializer(Object.class);
        }
    }
}

